/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.fluidconvertor.client;

import ipsis.woot.modules.fluidconvertor.FluidConvertorConfiguration;
import ipsis.woot.modules.fluidconvertor.blocks.FluidConvertorMenu;
import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FluidConvertorScreen
extends WootContainerScreen<FluidConvertorMenu> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/fluidconvertor.png");
    private static final int GUI_XSIZE = 180;
    private static final int GUI_YSIZE = 177;
    private static final int ENERGY_LX = 10;
    private static final int ENERGY_LY = 18;
    private static final int ENERGY_RX = 25;
    private static final int ENERGY_RY = 77;
    private static final int ENERGY_WIDTH = 16;
    private static final int ENERGY_HEIGHT = 60;
    private static final int IN_TANK_LX = 46;
    private static final int IN_TANK_LY = 18;
    private static final int IN_TANK_RX = 61;
    private static final int IN_TANK_RY = 77;
    private static final int IN_TANK_WIDTH = 16;
    private static final int IN_TANK_HEIGHT = 60;
    private static final int OUT_TANK_LX = 154;
    private static final int OUT_TANK_LY = 18;
    private static final int OUT_TANK_RX = 169;
    private static final int OUT_TANK_RY = 77;
    private static final int OUT_TANK_WIDTH = 16;
    private static final int OUT_TANK_HEIGHT = 60;
    private float currInputRender = 0.0f;
    private float currOutputRender = 0.0f;

    public FluidConvertorScreen(FluidConvertorMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.imageWidth = 180;
        this.imageHeight = 177;
        this.inventoryLabelY = this.imageHeight - 94;
        this.currInputRender = container.getInputFluid().getAmount();
        this.currOutputRender = container.getOutputFluid().getAmount();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (RenderHelper.isPointInRegion(46, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderFluidTankTooltip(guiGraphics, mouseX, mouseY, ((FluidConvertorMenu)this.menu).getInputFluid(), (Integer)FluidConvertorConfiguration.FLUID_CONV_INPUT_TANK_CAPACITY.get());
        }
        if (RenderHelper.isPointInRegion(154, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderFluidTankTooltip(guiGraphics, mouseX, mouseY, ((FluidConvertorMenu)this.menu).getOutputFluid(), (Integer)FluidConvertorConfiguration.FLUID_CONV_OUTPUT_TANK_CAPACITY.get());
        }
        if (RenderHelper.isPointInRegion(10, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, ((FluidConvertorMenu)this.menu).getEnergy(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get(), (Integer)InfuserConfiguration.INFUSER_ENERGY_PER_TICK.get());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((FluidConvertorMenu)this.menu).getProgress();
        guiGraphics.blit(this.GUI, this.getGuiLeft() + 73, this.getGuiTop() + 39, 180, 0, (int)(72.0f * ((float)progress / 100.0f)), 28);
        this.renderEnergyBar(guiGraphics, 10, 77, 60, 16, ((FluidConvertorMenu)this.menu).getEnergy(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get());
        float renderDiff = (float)((FluidConvertorMenu)this.menu).getInputFluid().getAmount() - this.currInputRender;
        if (renderDiff != 0.0f) {
            this.currInputRender = Math.abs(renderDiff) < 80.0f ? (float)((FluidConvertorMenu)this.menu).getInputFluid().getAmount() : (this.currInputRender += renderDiff * 0.05f);
        }
        this.renderFluidTank(guiGraphics, 46 + this.getGuiLeft(), 77 + this.getGuiTop(), 60, 16, (int)((Integer)FluidConvertorConfiguration.FLUID_CONV_INPUT_TANK_CAPACITY.get()), ((FluidConvertorMenu)this.menu).getInputFluid(), (int)this.currInputRender);
        renderDiff = (float)((FluidConvertorMenu)this.menu).getOutputFluid().getAmount() - this.currOutputRender;
        if (renderDiff != 0.0f) {
            this.currOutputRender = Math.abs(renderDiff) < 80.0f ? (float)((FluidConvertorMenu)this.menu).getOutputFluid().getAmount() : (this.currOutputRender += renderDiff * 0.05f);
        }
        this.renderFluidTank(guiGraphics, 154 + this.getGuiLeft(), 77 + this.getGuiTop(), 60, 16, (int)((Integer)FluidConvertorConfiguration.FLUID_CONV_OUTPUT_TANK_CAPACITY.get()), ((FluidConvertorMenu)this.menu).getOutputFluid(), (int)this.currOutputRender);
    }
}

