/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser;

import ipsis.woot.Woot;
import ipsis.woot.modules.infuser.blocks.InfuserBlock;
import ipsis.woot.modules.infuser.blocks.InfuserBlockEntity;
import ipsis.woot.modules.infuser.blocks.InfuserMenu;
import ipsis.woot.modules.infuser.items.DyeCasingItem;
import ipsis.woot.modules.infuser.items.DyePlateItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class InfuserSetup {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"woot");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"woot");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"woot");
    public static final String INFUSER_TAG = "infuser";
    public static final DeferredHolder<Block, InfuserBlock> INFUSER_BLOCK = BLOCKS.register("infuser", () -> new InfuserBlock());
    public static final DeferredHolder<Item, BlockItem> INFUSER_BLOCK_ITEM = ITEMS.register("infuser", () -> new BlockItem((Block)INFUSER_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<InfuserBlockEntity>> INFUSER_BLOCK_TILE = TILES.register("infuser", () -> BlockEntityType.Builder.of(InfuserBlockEntity::new, (Block[])new Block[]{(Block)INFUSER_BLOCK.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<InfuserMenu>> INFUSER_BLOCK_CONTAINER = CONTAINERS.register("infuser", () -> IMenuTypeExtension.create(InfuserMenu::new));
    public static final DeferredHolder<Item, DyePlateItem> WHITE_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.WHITE);
    public static final DeferredHolder<Item, DyePlateItem> ORANGE_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.ORANGE);
    public static final DeferredHolder<Item, DyePlateItem> MAGENTA_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.MAGENTA);
    public static final DeferredHolder<Item, DyePlateItem> LIGHT_BLUE_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.LIGHT_BLUE);
    public static final DeferredHolder<Item, DyePlateItem> YELLOW_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.YELLOW);
    public static final DeferredHolder<Item, DyePlateItem> LIME_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.LIME);
    public static final DeferredHolder<Item, DyePlateItem> PINK_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.PINK);
    public static final DeferredHolder<Item, DyePlateItem> GRAY_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.GRAY);
    public static final DeferredHolder<Item, DyePlateItem> LIGHT_GRAY_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.LIGHT_GRAY);
    public static final DeferredHolder<Item, DyePlateItem> CYAN_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.CYAN);
    public static final DeferredHolder<Item, DyePlateItem> PURPLE_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.PURPLE);
    public static final DeferredHolder<Item, DyePlateItem> BLUE_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.BLUE);
    public static final DeferredHolder<Item, DyePlateItem> BROWN_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.BROWN);
    public static final DeferredHolder<Item, DyePlateItem> GREEN_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.GREEN);
    public static final DeferredHolder<Item, DyePlateItem> RED_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.RED);
    public static final DeferredHolder<Item, DyePlateItem> BLACK_DYE_PLATE_ITEM = InfuserSetup.getDyePlateItem(ITEMS, DyeColor.BLACK);
    public static final DeferredHolder<Item, DyeCasingItem> WHITE_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.WHITE);
    public static final DeferredHolder<Item, DyeCasingItem> ORANGE_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.ORANGE);
    public static final DeferredHolder<Item, DyeCasingItem> MAGENTA_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.MAGENTA);
    public static final DeferredHolder<Item, DyeCasingItem> LIGHT_BLUE_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.LIGHT_BLUE);
    public static final DeferredHolder<Item, DyeCasingItem> YELLOW_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.YELLOW);
    public static final DeferredHolder<Item, DyeCasingItem> LIME_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.LIME);
    public static final DeferredHolder<Item, DyeCasingItem> PINK_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.PINK);
    public static final DeferredHolder<Item, DyeCasingItem> GRAY_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.GRAY);
    public static final DeferredHolder<Item, DyeCasingItem> LIGHT_GRAY_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.LIGHT_GRAY);
    public static final DeferredHolder<Item, DyeCasingItem> CYAN_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.CYAN);
    public static final DeferredHolder<Item, DyeCasingItem> PURPLE_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.PURPLE);
    public static final DeferredHolder<Item, DyeCasingItem> BLUE_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.BLUE);
    public static final DeferredHolder<Item, DyeCasingItem> BROWN_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.BROWN);
    public static final DeferredHolder<Item, DyeCasingItem> GREEN_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.GREEN);
    public static final DeferredHolder<Item, DyeCasingItem> RED_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.RED);
    public static final DeferredHolder<Item, DyeCasingItem> BLACK_DYE_CASING_ITEM = InfuserSetup.getDyeCasingItem(ITEMS, DyeColor.BLACK);

    public static void register(IEventBus eventBus) {
        Woot.setup.getLogger().info("InfuserSetup: register");
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILES.register(eventBus);
        CONTAINERS.register(eventBus);
    }

    private static DeferredHolder<Item, DyePlateItem> getDyePlateItem(DeferredRegister<Item> reg, DyeColor color) {
        return reg.register(color.getName() + "_dyeplate", () -> new DyePlateItem(color));
    }

    private static DeferredHolder<Item, DyeCasingItem> getDyeCasingItem(DeferredRegister<Item> reg, DyeColor color) {
        return reg.register(color.getName() + "_dyecasing", () -> new DyeCasingItem(color));
    }

    public static List<Item> getItems() {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toUnmodifiableList());
    }
}

