/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.blocks;

import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.modules.infuser.blocks.InfuserBlockEntity;
import ipsis.woot.util.WootBaseEntityBlock;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.helper.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class InfuserBlock
extends WootBaseEntityBlock
implements WootDebug {
    public InfuserBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InfuserBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof InfuserBlockEntity)) {
            throw new IllegalStateException("Tile entity is missing");
        }
        InfuserBlockEntity infuser = (InfuserBlockEntity)blockEntity;
        ItemStack heldItem = player.getItemInHand(hand);
        if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        if (infuser == null) {
            throw new IllegalStateException("Named container provider is missing");
        }
        player.openMenu((MenuProvider)infuser, infuser.getBlockPos());
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity te = level.getBlockEntity(pos);
            if (te instanceof InfuserBlockEntity) {
                ((InfuserBlockEntity)te).dropContents(level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt;
        super.appendHoverText(stack, context, tooltip, flagIn);
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compoundTag = nbt = data == null ? new CompoundTag() : data.copyTag();
        if (nbt.contains("energy")) {
            CompoundTag nbtEnergy = nbt.getCompound("energy");
            tooltip.add((Component)Component.translatable((String)"info.woot.energy", (Object[])new Object[]{nbtEnergy.getInt("energy"), InfuserConfiguration.INFUSER_MAX_ENERGY.get()}));
        }
        if (nbt.contains("tank")) {
            FluidStack fluidStack = (FluidStack)FluidStack.parse((HolderLookup.Provider)context.registries(), (Tag)nbt.getCompound("tank")).get();
            if (!fluidStack.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"info.woot.input_tank", (Object[])new Object[]{StringHelper.translate(fluidStack.getDescriptionId()), fluidStack.getAmount(), InfuserConfiguration.INFUSER_TANK_CAPACITY.get()}));
            } else {
                tooltip.add((Component)Component.translatable((String)"info.woot.input_tank.empty", (Object[])new Object[]{InfuserConfiguration.INFUSER_TANK_CAPACITY.get()}));
            }
        }
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> InfuserBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }
}

