/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.blocks;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.infuser.InfuserRecipe;
import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.infuser.blocks.InfuserMenu;
import ipsis.woot.util.EnchantingHelper;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootMachineBlockEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class InfuserBlockEntity
extends WootMachineBlockEntity
implements WootDebug,
MenuProvider {
    private boolean firstTick = true;
    public static final int INPUT_SLOT = 0;
    public static final int AUGMENT_SLOT = 1;
    public static final int OUTPUT_SLOT = 0;
    private InfuserRecipe currRecipe = null;

    public InfuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)InfuserSetup.INFUSER_BLOCK_TILE.get(), pos, state);
        this.stackInputHandler = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                InfuserBlockEntity.this.onContentsChanged(slot);
                InfuserBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return InfuserRecipe.isValidInput(stack);
                }
                if (slot == 1) {
                    return InfuserRecipe.isValidAugment(stack);
                }
                return false;
            }
        };
        this.stackOutputHandler = new ItemStackHandler();
    }

    public void configureSides() {
        Direction direction = (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (direction == Direction.NORTH) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.INPUT);
        } else if (direction == Direction.SOUTH) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.OUTPUT);
        } else if (direction == Direction.WEST) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.INPUT);
        } else if (direction == Direction.EAST) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void tick(Level level) {
        if (this.firstTick && level != null) {
            this.configureSides();
            this.firstTick = false;
        }
        super.tick(level);
    }

    public void setTankFluid(FluidStack fluidStack) {
        this.fluidInputHandler.setFluid(fluidStack);
    }

    public FluidStack getTankFluid() {
        return this.fluidInputHandler.getFluid();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot.infuser.name");
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyStorage.extractEnergy(((Integer)InfuserConfiguration.INFUSER_ENERGY_PER_TICK.get()).intValue(), false);
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.getEnergy() : 0;
    }

    @Override
    protected void processFinish() {
        ItemStack itemStack;
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        InfuserRecipe finishedRecipe = this.currRecipe;
        int inputSize = finishedRecipe.getIngredient().getItems()[0].getCount();
        int augmentSize = finishedRecipe.hasAugment() ? finishedRecipe.getAugment().getItems()[0].getCount() : 1;
        this.stackInputHandler.extractItem(0, inputSize, false);
        if (finishedRecipe.hasAugment()) {
            this.stackInputHandler.extractItem(1, augmentSize, false);
        }
        if ((itemStack = finishedRecipe.getOutput()).getItem() == Items.ENCHANTED_BOOK) {
            int level = itemStack.getCount();
            itemStack = new ItemStack((ItemLike)Items.BOOK, 1);
            itemStack = EnchantingHelper.addRandomBookEnchant(itemStack, level, this.getLevel().registryAccess());
        }
        this.stackOutputHandler.insertItem(0, itemStack.copy(), false);
        this.fluidInputHandler.drain(finishedRecipe.getFluidInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.stackInputHandler.getStackInSlot(0).isEmpty()) {
            return false;
        }
        if (this.fluidInputHandler.isEmpty()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        if (this.currRecipe.hasAugment() && this.currRecipe.getAugmentCount() > this.stackInputHandler.getStackInSlot(1).getCount()) {
            return false;
        }
        FluidStack fluidStack = this.fluidInputHandler.getFluid();
        if (!fluidStack.is(this.currRecipe.getFluidInput().getFluidType())) {
            return false;
        }
        if (this.stackOutputHandler.getStackInSlot(0).isEmpty()) {
            return true;
        }
        ItemStack outStack = this.stackOutputHandler.getStackInSlot(0);
        if (outStack.getCount() == outStack.getMaxStackSize()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)this.currRecipe.getOutput(), (ItemStack)this.stackOutputHandler.getStackInSlot(0));
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        if (this.stackInputHandler.getStackInSlot(0).isEmpty()) {
            return false;
        }
        if (this.currRecipe.hasAugment() && this.currRecipe.getAugmentCount() > this.stackInputHandler.getStackInSlot(1).getCount()) {
            return false;
        }
        FluidStack fluidStack = this.fluidInputHandler.getFluid();
        return fluidStack.is(this.currRecipe.getFluidInput().getFluidType());
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        if (this.fluidInputHandler.isEmpty()) {
            this.clearRecipe();
            return;
        }
        List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)WootRecipes.INFUSER_TYPE.get());
        if (!recipes.isEmpty()) {
            FluidStack fluidStack = this.fluidInputHandler.getFluid();
            for (RecipeHolder r : recipes) {
                if (!((InfuserRecipe)r.value()).getFluidInput().is(fluidStack.getFluid())) continue;
                this.currRecipe = (InfuserRecipe)r.value();
                return;
            }
        }
        this.clearRecipe();
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(0);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.stackInputHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        if (!(itemStack = this.stackInputHandler.getStackInSlot(1)).isEmpty()) {
            drops.add(itemStack);
            this.stackInputHandler.setStackInSlot(1, ItemStack.EMPTY);
        }
        if (!(itemStack = this.stackOutputHandler.getStackInSlot(0)).isEmpty()) {
            drops.add(itemStack);
            this.stackOutputHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        super.dropContents(drops);
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> InfuserTileEntity");
        debug.add("      Tank " + this.getTankFluid().getDescriptionId() + " " + this.getTankFluid().getAmount());
        debug.add("      Energy " + this.getEnergy());
        return debug;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new InfuserMenu(i, inventory, this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)InfuserSetup.INFUSER_BLOCK_TILE.get(), (be, direction) -> be.energyStorage);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)InfuserSetup.INFUSER_BLOCK_TILE.get(), (be, direction) -> {
            if (direction == ((Direction)be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise() || direction == Direction.DOWN) {
                return be.fluidOutputHandler;
            }
            return be.fluidInputHandler;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)InfuserSetup.INFUSER_BLOCK_TILE.get(), (be, direction) -> {
            if (direction == ((Direction)be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise() || direction == Direction.DOWN) {
                return be.stackOutputHandler;
            }
            return be.stackInputHandler;
        });
    }
}

