/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.blocks;

import ipsis.woot.crafting.infuser.InfuserRecipe;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.infuser.blocks.InfuserBlockEntity;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class InfuserMenu
extends WootContainer
implements TankPacketHandler {
    public InfuserBlockEntity blockEntity;
    public Inventory playerInventory;
    private int progress = 0;
    private FluidStack inputFluid = FluidStack.EMPTY;
    private int energy = 0;

    public InfuserMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public InfuserMenu(int windowId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)InfuserSetup.INFUSER_BLOCK_CONTAINER.get(), windowId);
        this.blockEntity = (InfuserBlockEntity)entity;
        if (!entity.getLevel().isClientSide) {
            TankPacket tankPacket = new TankPacket(this.inputFluid, 0);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)playerInventory.player), (CustomPacketPayload)tankPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.playerInventory = playerInventory;
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory);
        this.addListeners();
    }

    private void addOwnSlots() {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.stackInputHandler, 0, 46, 40));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.stackInputHandler, 1, 64, 40));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.stackOutputHandler, 0, 118, 40));
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 10 + col * 18;
                int y = row * 18 + 95;
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 10 + row * 18;
            this.addSlot(new Slot((Container)playerInventory, row, x, 153));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergy() {
        return this.energy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity.getLevel().isClientSide) {
            return;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.inputFluid, (FluidStack)this.blockEntity.getTankFluid()) || this.inputFluid.getAmount() != this.blockEntity.getTankFluid().getAmount()) {
            this.inputFluid = this.blockEntity.getTankFluid().copy();
            TankPacket tankPacket = new TankPacket(this.inputFluid, 0);
            if (this.playerInventory.player instanceof ServerPlayer) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.playerInventory.player), (CustomPacketPayload)tankPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return InfuserMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)this.blockEntity.getBlockPos()), (Player)playerIn, (Block)((Block)InfuserSetup.INFUSER_BLOCK.get()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        int MACHINE_INV_SIZE = 3;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 3) {
            if (InfuserRecipe.isValidInput(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (InfuserRecipe.isValidAugment(stack)) {
                startIndex = 1;
                endIndex = 2;
            } else if (index < 30) {
                startIndex = 30;
                endIndex = startIndex + 9;
            } else {
                if (index < 30) return ItemStack.EMPTY;
                startIndex = 3;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 3;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.moveItemStackTo(stack, startIndex, endIndex, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stack);
        return stackCopy;
    }

    public void addListeners() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.blockEntity.getEnergy();
            }

            public void set(int i) {
                InfuserMenu.this.energy = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.blockEntity.getProgress();
            }

            public void set(int i) {
                if (i < InfuserMenu.this.progress) {
                    InfuserMenu.this.broadcastChanges();
                }
                InfuserMenu.this.progress = i;
            }
        });
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId() == 0) {
            this.inputFluid = packet.fluidStack();
        }
    }
}

