/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.client;

import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.modules.infuser.blocks.InfuserMenu;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class InfuserScreen
extends WootContainerScreen<InfuserMenu> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/infuser.png");
    private static final int GUI_XSIZE = 180;
    private static final int GUI_YSIZE = 177;
    private static final int ENERGY_LX = 10;
    private static final int ENERGY_LY = 18;
    private static final int ENERGY_RX = 25;
    private static final int ENERGY_RY = 77;
    private static final int ENERGY_WIDTH = 16;
    private static final int ENERGY_HEIGHT = 60;
    private static final int TANK_LX = 154;
    private static final int TANK_LY = 18;
    private static final int TANK_RX = 169;
    private static final int TANK_RY = 77;
    private static final int TANK_WIDTH = 16;
    private static final int TANK_HEIGHT = 60;
    private int currFluidRender = 0;

    public InfuserScreen(InfuserMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.imageWidth = 180;
        this.imageHeight = 177;
        this.inventoryLabelY = this.imageHeight - 94;
        this.currFluidRender = ((InfuserMenu)this.menu).getInputFluid().getAmount();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (RenderHelper.isPointInRegion(154, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderFluidTankTooltip(guiGraphics, mouseX, mouseY, ((InfuserMenu)this.menu).getInputFluid(), (Integer)InfuserConfiguration.INFUSER_TANK_CAPACITY.get());
        }
        if (RenderHelper.isPointInRegion(10, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, ((InfuserMenu)this.menu).getEnergy(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get(), (Integer)InfuserConfiguration.INFUSER_ENERGY_PER_TICK.get());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((InfuserMenu)this.menu).getProgress();
        guiGraphics.blit(this.GUI, this.getGuiLeft() + 90, this.getGuiTop() + 39, 180, 0, (int)(18.0f * ((float)progress / 100.0f)), 17);
        this.renderEnergyBar(guiGraphics, 10, 77, 60, 16, ((InfuserMenu)this.menu).getEnergy(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get());
        int renderDiff = ((InfuserMenu)this.menu).getInputFluid().getAmount() - this.currFluidRender;
        if (renderDiff != 0) {
            this.currFluidRender = Math.abs(renderDiff) < 20 ? ((InfuserMenu)this.menu).getInputFluid().getAmount() : (this.currFluidRender += (int)Math.ceil((float)renderDiff * 0.08f));
        }
        this.renderFluidTank(guiGraphics, 154 + this.getGuiLeft(), 77 + this.getGuiTop(), 60, 16, (int)((Integer)InfuserConfiguration.INFUSER_TANK_CAPACITY.get()), ((InfuserMenu)this.menu).getInputFluid(), this.currFluidRender);
    }
}

