/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout;

import ipsis.woot.Woot;
import ipsis.woot.modules.layout.blocks.LayoutBlock;
import ipsis.woot.modules.layout.blocks.LayoutBlockEntity;
import ipsis.woot.modules.layout.items.InternItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class LayoutSetup {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"woot");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"woot");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"woot");
    public static final String LAYOUT_TAG = "layout";
    public static final DeferredHolder<Block, LayoutBlock> LAYOUT_BLOCK = BLOCKS.register("layout", () -> new LayoutBlock());
    public static final DeferredHolder<Item, BlockItem> LAYOUT_BLOCK_ITEM = ITEMS.register("layout", () -> new BlockItem((Block)LAYOUT_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<LayoutBlockEntity>> LAYOUT_BLOCK_TILE = TILES.register("layout", () -> BlockEntityType.Builder.of(LayoutBlockEntity::new, (Block[])new Block[]{(Block)LAYOUT_BLOCK.get()}).build(null));
    public static final DeferredHolder<Item, InternItem> INTERN_ITEM = ITEMS.register("intern", () -> new InternItem());

    public static void register(IEventBus eventBus) {
        Woot.setup.getLogger().info("LayoutSetup: register");
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILES.register(eventBus);
        CONTAINERS.register(eventBus);
    }

    public static List<Item> getItems() {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toUnmodifiableList());
    }
}

