/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.blocks;

import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.modules.layout.LayoutSetup;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class LayoutBlockEntity
extends BlockEntity {
    private static final int LAYOUT_Y_OFFSET = 1;
    AbsolutePattern absolutePattern = null;
    Tier tier = Tier.TIER_1;
    int yLevel = -1;
    static final String KEY_LEVEL = "yLevel";
    static final String KEY_TIER = "tier";

    public LayoutBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LayoutSetup.LAYOUT_BLOCK_TILE.get(), pos, state);
    }

    public int getYLevel() {
        return this.yLevel;
    }

    public int setNextLevel() {
        ++this.yLevel;
        if (this.yLevel >= PatternRepository.get().getPattern(this.tier).getHeight()) {
            this.yLevel = -1;
        }
        this.setChanged();
        this.refresh();
        return this.yLevel;
    }

    public int getYForLevel() {
        int height = PatternRepository.get().getPattern(this.tier).getHeight();
        return this.getBlockPos().getY() - height - 1 + this.yLevel + 2;
    }

    public Tier getTier() {
        return this.tier;
    }

    public Tier setNextTier() {
        this.tier = this.tier.getNextValid();
        this.setChanged();
        this.refresh();
        return this.tier;
    }

    public void refresh() {
        if (!this.level.isClientSide) {
            return;
        }
        BlockPos origin = this.getBlockPos().below(1);
        this.absolutePattern = AbsolutePattern.create(this.level, this.tier, origin, (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public AbsolutePattern getAbsolutePattern() {
        return this.absolutePattern;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compoundNBT = this.getUpdateTag((HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
        this.refresh();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProviders) {
        CompoundTag compoundNBT = super.getUpdateTag((HolderLookup.Provider)this.level.registryAccess());
        this.saveAdditional(compoundNBT, (HolderLookup.Provider)this.level.registryAccess());
        return compoundNBT;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt(KEY_LEVEL, this.yLevel);
        tag.putInt(KEY_TIER, this.tier.ordinal());
    }

    public void loadAdditional(CompoundTag compoundNBT, HolderLookup.Provider registries) {
        super.loadAdditional(compoundNBT, registries);
        this.readFromNBT(compoundNBT);
    }

    private void readFromNBT(CompoundTag compound) {
        this.yLevel = Math.clamp((long)compound.getInt(KEY_LEVEL), -1, 16);
        this.tier = Tier.byIndex(compound.getInt(KEY_TIER));
    }
}

