/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.modules.layout.blocks.LayoutBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class LayoutTileEntitySpecialRenderer
implements BlockEntityRenderer<LayoutBlockEntity> {
    public static final Dispatcher DISPATCHER = new Dispatcher();

    void textureRender(LayoutBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean showAll = true;
        int validY = showAll ? 0 : tileEntityIn.getYForLevel();
        BlockPos origin = tileEntityIn.getBlockPos();
        Direction facing = Direction.SOUTH;
        Block layoutBlock = tileEntityIn.getLevel().getBlockState(origin).getBlock();
        if (layoutBlock == LayoutSetup.LAYOUT_BLOCK.get()) {
            facing = (Direction)tileEntityIn.getLevel().getBlockState(origin).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 0.0f);
        for (PatternBlock block : tileEntityIn.getAbsolutePattern().getBlocks()) {
            matrixStack.pushPose();
            float x = (float)(origin.getX() - block.getBlockPos().getX()) * -1.0f;
            float y = (float)(origin.getY() - block.getBlockPos().getY()) * -1.0f;
            float z = (float)(origin.getZ() - block.getBlockPos().getZ()) * -1.0f;
            matrixStack.translate(x, y, z);
            minX = Math.min(x, minX);
            minY = Math.min(y, minY);
            minZ = Math.min(z, minZ);
            maxX = Math.max(x, maxX);
            maxY = Math.max(y, maxY);
            maxZ = Math.max(z, maxZ);
            BlockState blockState = block.getFactoryComponent().getDefaultBlockState();
            if (block.getFactoryComponent() == FactoryComponent.HEART) {
                blockState = (BlockState)((HeartBlock)FactorySetup.HEART_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            }
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockState, matrixStack, bufferIn, 0xF000F0, combinedOverlayIn, ModelData.EMPTY, RenderType.solid());
            matrixStack.popPose();
        }
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 0.0f);
        VertexConsumer iVertexBuilder = bufferIn.getBuffer((RenderType)RenderType.LINES);
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)iVertexBuilder, (double)minX, (double)minY, (double)minZ, (double)(maxX += 1.0f), (double)(maxY += 1.0f), (double)(maxZ += 1.0f), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
        matrixStack.popPose();
    }

    public void render(LayoutBlockEntity layoutBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        Level world = layoutBlockEntity.getLevel();
        if (world != null) {
            if (layoutBlockEntity.getAbsolutePattern() == null) {
                layoutBlockEntity.refresh();
            }
            if (layoutBlockEntity.getAbsolutePattern() == null) {
                return;
            }
            this.textureRender(layoutBlockEntity, v, poseStack, multiBufferSource, i, i1);
        }
    }

    public AABB getRenderBoundingBox(LayoutBlockEntity blockEntity) {
        return AABB.INFINITE;
    }

    public boolean shouldRenderOffScreen(LayoutBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(LayoutBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public static class Dispatcher
    implements BlockEntityRendererProvider<LayoutBlockEntity> {
        public BlockEntityRenderer<LayoutBlockEntity> create(BlockEntityRendererProvider.Context context) {
            return new LayoutTileEntitySpecialRenderer();
        }
    }
}

