/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.items;

import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.layout.FactoryHelper;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.util.helper.RandomHelper;
import ipsis.woot.util.helper.StringHelper;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class InternItem
extends Item {
    private static final String NBT_MODE = "mode";

    public InternItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        return this.useOnFirst(context);
    }

    private boolean firstUse(ItemStack stack) {
        CompoundTag tag;
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = tag = data == null ? new CompoundTag() : data.copyTag();
        if (tag.contains("USEDONCE")) {
            return false;
        }
        tag.putInt("USEDONCE", 1);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return true;
    }

    private static void setToolModeInStack(ItemStack itemStack, ToolMode toolMode) {
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compound = data == null ? new CompoundTag() : data.copyTag();
        compound.putString(NBT_MODE, toolMode.name());
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    private static ToolMode getToolModeFromStack(ItemStack itemStack) {
        CompoundTag compound;
        ToolMode mode = ToolMode.BUILD_1;
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = compound = data == null ? new CompoundTag() : data.copyTag();
        if (!compound.contains(NBT_MODE)) {
            InternItem.setToolModeInStack(itemStack, mode);
        } else {
            try {
                mode = ToolMode.valueOf(compound.getString(NBT_MODE));
            }
            catch (Exception e) {
                InternItem.setToolModeInStack(itemStack, mode);
            }
        }
        return mode;
    }

    public InteractionResult useOnFirst(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult result = InteractionResult.PASS;
        ItemStack itemStack = context.getItemInHand();
        Player playerEntity = context.getPlayer();
        if (!playerEntity.isCrouching() && !context.getLevel().isClientSide) {
            Block b = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
            if (b instanceof HeartBlock) {
                BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
                Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                ToolMode toolMode = InternItem.getToolModeFromStack(itemStack);
                if (toolMode.isBuildMode() && context.getPlayer().mayInteract(context.getLevel(), context.getClickedPos())) {
                    FactoryHelper.BuildResult buildResult = FactoryHelper.tryBuild(context.getLevel(), context.getClickedPos(), context.getPlayer(), facing, toolMode.getTier());
                    if (buildResult == FactoryHelper.BuildResult.SUCCESS) {
                        context.getLevel().playSound(null, context.getPlayer().getX(), context.getPlayer().getY(), context.getPlayer().getZ(), SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.5f * ((RandomHelper.RANDOM.nextFloat() - RandomHelper.RANDOM.nextFloat()) * 0.7f + 1.8f));
                    } else if (buildResult == FactoryHelper.BuildResult.ALL_BLOCKS_PLACED) {
                        FactoryHelper.tryValidate(context.getLevel(), context.getClickedPos(), context.getPlayer(), facing, toolMode.getTier());
                    } else {
                        context.getLevel().playSound(null, context.getPlayer().getX(), context.getPlayer().getY(), context.getPlayer().getZ(), SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    result = InteractionResult.SUCCESS;
                } else if (toolMode.isValidateMode()) {
                    if (!context.getLevel().isClientSide) {
                        FactoryHelper.tryValidate(context.getLevel(), context.getClickedPos(), context.getPlayer(), facing, toolMode.getTier());
                    }
                    result = InteractionResult.SUCCESS;
                }
            }
        } else if (playerEntity.isCrouching()) {
            BlockHitResult rayTraceResult = InternItem.getPlayerPOVHitResult((Level)context.getLevel(), (Player)playerEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            ToolMode mode = InternItem.getToolModeFromStack(itemStack);
            mode = mode.getNext();
            InternItem.setToolModeInStack(itemStack, mode);
            if (mode.isBuildMode()) {
                playerEntity.sendSystemMessage((Component)Component.translatable((String)"info.woot.intern.mode.build", (Object[])new Object[]{StringHelper.translate(mode.getTier().getTranslationKey())}));
            } else if (mode.isValidateMode()) {
                playerEntity.sendSystemMessage((Component)Component.translatable((String)"info.woot.intern.mode.validate", (Object[])new Object[]{StringHelper.translate(mode.getTier().getTranslationKey())}));
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    void spawnParticle(Level world, BlockPos pos, int amount) {
        BlockState blockState = world.getBlockState(pos);
        Block b = world.getBlockState(pos).getBlock();
        if (b.isEmpty(blockState)) {
            for (int i = 0; i < amount; ++i) {
                double d0 = RandomHelper.RANDOM.nextGaussian() * 0.02;
                double d1 = RandomHelper.RANDOM.nextGaussian() * 0.02;
                double d2 = RandomHelper.RANDOM.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)((float)pos.getX() + RandomHelper.RANDOM.nextFloat()), (double)((float)pos.getY() + RandomHelper.RANDOM.nextFloat()), (double)((float)pos.getZ() + RandomHelper.RANDOM.nextFloat()), d0, d1, d2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)StringHelper.translate("info.woot.intern")));
        tooltip.add((Component)Component.translatable((String)StringHelper.translate("info.woot.intern.0")));
        tooltip.add((Component)Component.translatable((String)StringHelper.translate("info.woot.intern.1")));
        ToolMode toolMode = InternItem.getToolModeFromStack(stack);
        if (toolMode.isBuildMode()) {
            tooltip.add((Component)Component.translatable((String)StringHelper.translateFormat("info.woot.intern.mode.build", StringHelper.translate(toolMode.getTier().getTranslationKey()))));
            PatternRepository.Pattern pattern = PatternRepository.get().getPattern(toolMode.getTier());
            if (pattern != null) {
                for (FactoryComponent component : FactoryComponent.VALUES) {
                    int count = pattern.getFactoryBlockCount(component);
                    if (count <= 0) continue;
                    String key = "info.woot.intern.other.count";
                    MutableComponent text = Component.translatable((String)component.getTranslationKey());
                    if (component == FactoryComponent.CELL) {
                        text = Component.translatable((String)"info.woot.intern.cell");
                    } else if (toolMode == ToolMode.BUILD_1 && component == FactoryComponent.CONTROLLER) {
                        key = "info.woot.intern.controller.count.0";
                    } else if (component == FactoryComponent.CONTROLLER) {
                        key = "info.woot.intern.controller.count.1";
                    }
                    tooltip.add((Component)Component.translatable((String)key, (Object[])new Object[]{count, text}));
                }
            }
        } else if (toolMode.isValidateMode()) {
            tooltip.add((Component)Component.translatable((String)StringHelper.translateFormat("info.woot.intern.mode.validate", StringHelper.translate(toolMode.getTier().getTranslationKey()))));
        }
    }

    public static enum ToolMode {
        BUILD_1(Tier.TIER_1),
        BUILD_2(Tier.TIER_2),
        BUILD_3(Tier.TIER_3),
        BUILD_4(Tier.TIER_4),
        BUILD_5(Tier.TIER_5),
        VALIDATE_1(Tier.TIER_1),
        VALIDATE_2(Tier.TIER_2),
        VALIDATE_3(Tier.TIER_3),
        VALIDATE_4(Tier.TIER_4),
        VALIDATE_5(Tier.TIER_5);

        public static ToolMode[] VALUES;
        private static EnumSet<ToolMode> BUILD_MODES;
        private static EnumSet<ToolMode> VALIDATE_TIERS;
        Tier tier;

        public ToolMode getNext() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public boolean isBuildMode() {
            return BUILD_MODES.contains((Object)this);
        }

        public boolean isValidateMode() {
            return VALIDATE_TIERS.contains((Object)this);
        }

        private ToolMode(Tier tier) {
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        static {
            VALUES = ToolMode.values();
            BUILD_MODES = EnumSet.range(BUILD_1, BUILD_5);
            VALIDATE_TIERS = EnumSet.range(VALIDATE_1, VALIDATE_5);
        }
    }
}

