/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle;

import ipsis.woot.Woot;
import ipsis.woot.modules.oracle.blocks.OracleBlock;
import ipsis.woot.modules.oracle.blocks.OracleContainer;
import ipsis.woot.modules.oracle.blocks.OracleTileEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OracleSetup {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"woot");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"woot");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"woot");
    public static final String ORACLE_TAG = "oracle";
    public static final DeferredHolder<Block, OracleBlock> ORACLE_BLOCK = BLOCKS.register("oracle", () -> new OracleBlock(BlockBehaviour.Properties.of()));
    public static final DeferredHolder<Item, Item> ORACLE_BLOCK_ITEM = ITEMS.register("oracle", () -> new BlockItem((Block)ORACLE_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> ORACLE_BLOCK_TILE = TILES.register("oracle", () -> BlockEntityType.Builder.of(OracleTileEntity::new, (Block[])new Block[]{(Block)ORACLE_BLOCK.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<OracleContainer>> ORACLE_BLOCK_CONTAINER = CONTAINERS.register("oracle", () -> IMenuTypeExtension.create(OracleContainer::new));

    public static void register(IEventBus eventBus) {
        Woot.setup.getLogger().info("OracleSetup: register");
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILES.register(eventBus);
        CONTAINERS.register(eventBus);
    }

    public static List<Item> getItems() {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toUnmodifiableList());
    }
}

