/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.blocks;

import com.mojang.serialization.MapCodec;
import ipsis.woot.modules.oracle.blocks.OracleTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OracleBlock
extends Block
implements EntityBlock {
    public static final MapCodec CODEC = OracleBlock.simpleCodec(OracleBlock::new);

    public OracleBlock(BlockBehaviour.Properties prop) {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof OracleTileEntity)) {
            throw new IllegalStateException("Named container provider is missing");
        }
        OracleTileEntity ot = (OracleTileEntity)te;
        ((ServerPlayer)player).openMenu((MenuProvider)ot, pos);
        return ItemInteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new OracleTileEntity(blockPos, blockState);
    }
}

