/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.blocks;

import ipsis.woot.modules.oracle.OracleSetup;
import ipsis.woot.modules.oracle.network.SimulatedMobDropsSummaryReply;
import ipsis.woot.modules.oracle.network.SimulatedMobsReply;
import ipsis.woot.setup.ServerDataRequest;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class OracleContainer
extends AbstractContainerMenu {
    public BlockEntity tileEntity;
    public List<FakeMob> simulatedMobs = new ArrayList<FakeMob>();
    public List<SimulatedMobDropSummary> simulatedDrops = new ArrayList<SimulatedMobDropSummary>();

    public OracleContainer(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public OracleContainer(int windowId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)OracleSetup.ORACLE_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = entity;
    }

    public BlockPos getPos() {
        return this.tileEntity.getBlockPos();
    }

    public void refreshMobs() {
        this.simulatedMobs.clear();
        this.simulatedDrops.clear();
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerDataRequest("", this.getPos(), ServerDataRequest.Type.DROP_REGISTRY_STATUS.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void refreshDrops(int index) {
        if (this.simulatedMobs.size() > index) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerDataRequest(this.simulatedMobs.get(index).getName(), this.getPos(), ServerDataRequest.Type.SIMULATED_MOB_DROPS.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.simulatedDrops.clear();
    }

    public void handleSimulatedMobsReply(SimulatedMobsReply msg) {
        this.simulatedMobs.clear();
        this.simulatedMobs.addAll(msg.simulatedMobs());
        if (!this.simulatedMobs.isEmpty()) {
            this.refreshDrops(0);
        }
    }

    public void handleSimulatedMobDropsSummaryReply(SimulatedMobDropsSummaryReply msg) {
        this.simulatedDrops.clear();
        this.simulatedDrops.addAll(msg.drops());
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return null;
    }

    public boolean stillValid(@NotNull Player player) {
        return OracleContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.tileEntity.getBlockPos()), (Player)player, (Block)((Block)OracleSetup.ORACLE_BLOCK.get()));
    }
}

