/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.client;

import ipsis.woot.modules.oracle.blocks.OracleContainer;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class OracleScreen
extends AbstractContainerScreen<OracleContainer> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/oracle.png");
    private Button nextMobButton;
    private Button prevMobButton;
    private int mobIndex = 0;

    public OracleScreen(OracleContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, (Component)Component.translatable((String)"gui.woot.oracle.name"));
        this.imageWidth = 180;
        this.imageHeight = 177;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.titleLabelX + this.getGuiLeft(), this.titleLabelY + this.getGuiTop(), 0x404040, false);
        if (((OracleContainer)this.menu).simulatedMobs.isEmpty()) {
            String mob = "N/A";
            guiGraphics.drawString(this.font, mob, this.imageWidth / 2 - this.font.width(mob) / 2 + this.getGuiLeft(), 25 + this.getGuiTop(), 0x404040, false);
        } else {
            FakeMob fakeMob = ((OracleContainer)this.menu).simulatedMobs.get(this.mobIndex);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(fakeMob.getResourceLocation());
            if (entityType != null) {
                Object mob = Component.literal((String)entityType.toShortString()).getString();
                if (fakeMob.hasTag()) {
                    mob = (String)mob + "[" + fakeMob.getTag() + "]";
                }
                guiGraphics.drawString(this.font, (String)mob, this.getGuiLeft() + (this.imageWidth / 2 - this.font.width((String)mob) / 2), this.getGuiTop() + 25, 0x404040, false);
            }
        }
        if (!((OracleContainer)this.menu).simulatedDrops.isEmpty()) {
            int currRow = 0;
            int currCol = 0;
            for (SimulatedMobDropSummary summary : ((OracleContainer)this.menu).simulatedDrops) {
                int stackX = currCol * 18 + 10;
                int stackY = currRow * 18 + 41;
                if (mouseX - this.leftPos > stackX && mouseX - this.leftPos <= stackX + 20 && mouseY - this.topPos >= stackY && mouseY - this.topPos <= stackY + 20) {
                    Font fontRenderer = Minecraft.getInstance().font;
                    List tooltip = OracleScreen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)summary.stack());
                    tooltip.add(Component.translatable((String)"gui.woot.oracle.looting.0", (Object[])new Object[]{summary.chanceToDrop().getFirst()}));
                    tooltip.add(Component.translatable((String)"gui.woot.oracle.looting.1", (Object[])new Object[]{summary.chanceToDrop().get(1)}));
                    tooltip.add(Component.translatable((String)"gui.woot.oracle.looting.2", (Object[])new Object[]{summary.chanceToDrop().get(2)}));
                    tooltip.add(Component.translatable((String)"gui.woot.oracle.looting.3", (Object[])new Object[]{summary.chanceToDrop().get(3)}));
                    guiGraphics.renderTooltip(fontRenderer, tooltip, summary.stack().getTooltipImage(), summary.stack(), mouseX - this.leftPos, mouseY - this.topPos);
                    break;
                }
                if (++currCol != 9) continue;
                currCol = 0;
                ++currRow;
            }
        }
    }

    protected void init() {
        super.init();
        this.nextMobButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), h -> {
            if (!((OracleContainer)this.menu).simulatedMobs.isEmpty()) {
                ++this.mobIndex;
                this.mobIndex = Math.clamp((long)this.mobIndex, 0, ((OracleContainer)this.menu).simulatedMobs.size() - 1);
                ((OracleContainer)this.menu).refreshDrops(this.mobIndex);
            }
        }).bounds(this.leftPos + 9 + 144, this.topPos + 18, 18, 18).build());
        this.prevMobButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), h -> {
            if (!((OracleContainer)this.menu).simulatedMobs.isEmpty()) {
                --this.mobIndex;
                this.mobIndex = Math.clamp((long)this.mobIndex, 0, ((OracleContainer)this.menu).simulatedMobs.size() - 1);
                ((OracleContainer)this.menu).refreshDrops(this.mobIndex);
            }
        }).bounds(this.leftPos + 9, this.topPos + 18, 18, 18).build());
        ((OracleContainer)this.menu).refreshMobs();
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        if (!((OracleContainer)this.menu).simulatedDrops.isEmpty()) {
            int currRow = 0;
            int currCol = 0;
            for (SimulatedMobDropSummary summary : ((OracleContainer)this.menu).simulatedDrops) {
                int stackX = this.leftPos + currCol * 18 + 10;
                int stackY = this.topPos + currRow * 18 + 41;
                guiGraphics.renderItem(summary.stack(), stackX, stackY);
                if (++currCol != 9) continue;
                currCol = 0;
                ++currRow;
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

