/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.network;

import ipsis.woot.modules.oracle.blocks.OracleContainer;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SimulatedMobDropsSummaryReply(List<SimulatedMobDropSummary> drops) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SimulatedMobDropsSummaryReply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"simmobdropsummaryreply"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimulatedMobDropsSummaryReply> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, SimulatedMobDropSummary.STREAM_CODEC), SimulatedMobDropsSummaryReply::drops, SimulatedMobDropsSummaryReply::new);

    public static SimulatedMobDropsSummaryReply fromMob(String entityKey) {
        SimulatedMobDropsSummaryReply reply = new SimulatedMobDropsSummaryReply(new ArrayList<SimulatedMobDropSummary>());
        FakeMob fakeMob = new FakeMob(entityKey);
        if (fakeMob.isValid()) {
            reply.drops.addAll(MobSimulator.getInstance().getDropSummary(fakeMob));
        }
        return reply;
    }

    public static void handle(SimulatedMobDropsSummaryReply packet, IPayloadContext ctx) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.containerMenu instanceof OracleContainer) {
            ((OracleContainer)player.containerMenu).handleSimulatedMobDropsSummaryReply(packet);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

