/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.dyesqueezer.DyeSqueezerRecipe;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerContainer;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootFluidTank;
import ipsis.woot.util.WootMachineBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class DyeSqueezerBlockEntity
extends WootMachineBlockEntity
implements WootDebug,
MenuProvider {
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    private WootFluidTank outputTank = this.createTank();
    private DyeSqueezerRecipe currRecipe = null;
    private boolean dumpExcess = false;

    public DyeSqueezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SqueezerSetup.SQUEEZER_BLOCK_TILE.get(), pos, state);
        this.stackInputHandler = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                DyeSqueezerBlockEntity.this.onContentsChanged(slot);
                DyeSqueezerBlockEntity.this.setChanged();
            }

            public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
                return slot == 0 ? DyeSqueezerRecipe.isValidInput(stack) : false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void onLoad() {
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, WootMachineBlockEntity.Mode.OUTPUT);
        }
    }

    private WootFluidTank createTank() {
        return new WootFluidTank((Integer)SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get(), h -> h.is(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 1).getFluidType())).setAccess(false, true);
    }

    public FluidStack getOutputTankFluid() {
        return this.outputTank.getFluid();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.readFromNBT(tag, registries);
        super.loadAdditional(tag, registries);
    }

    private void readFromNBT(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag tankTag = tag.getCompound("OutputTank");
        FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tankTag);
        this.outputTank.setFluid(fluidStack);
        if (tag.contains("InternalTanks")) {
            CompoundTag dyeTag = tag.getCompound("InternalTanks");
            this.red = dyeTag.getInt("Red");
            this.yellow = dyeTag.getInt("Yellow");
            this.blue = dyeTag.getInt("Blue");
            this.white = dyeTag.getInt("White");
        }
        if (tag.contains("Excess")) {
            this.dumpExcess = tag.getBoolean("Excess");
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (!this.outputTank.getFluid().isEmpty()) {
            Tag tankTag = this.outputTank.getFluid().save(registries);
            tag.put("OutputTank", tankTag);
        }
        CompoundTag dyeTag = new CompoundTag();
        dyeTag.putInt("Red", this.red);
        dyeTag.putInt("Yellow", this.yellow);
        dyeTag.putInt("Blue", this.blue);
        dyeTag.putInt("White", this.white);
        tag.put("InternalTanks", (Tag)dyeTag);
        tag.putBoolean("Excess", this.dumpExcess);
        super.saveAdditional(tag, registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot.squeezer.name");
    }

    public int getRed() {
        return this.red;
    }

    public int getYellow() {
        return this.yellow;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getWhite() {
        return this.white;
    }

    public boolean getDumpExcess() {
        return this.dumpExcess;
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % 20L == 0L) {
            this.generatePureFluid();
        }
        if (this.outputTank.isEmpty()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            Optional<IFluidHandler> lazyOptional;
            BlockEntity te = level.getBlockEntity(this.getBlockPos().offset(direction.getNormal()));
            if (te == null || !(lazyOptional = Optional.ofNullable((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)direction.getOpposite()))).isPresent()) continue;
            IFluidHandler iFluidHandler = lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = this.outputTank.getFluid();
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.outputTank.internalDrain(filled, IFluidHandler.FluidAction.EXECUTE);
            this.setChanged();
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyStorage.extractEnergy(((Integer)SqueezerConfiguration.DYE_SQUEEZER_ENERGY_PER_TICK.get()).intValue(), false);
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.energy() : 0;
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    private void generatePureFluid() {
        while (this.canCreateOutput() && this.canStoreOutput()) {
            this.outputTank.internalFill(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 288), IFluidHandler.FluidAction.EXECUTE);
            this.red -= 72;
            this.yellow -= 72;
            this.blue -= 72;
            this.white -= 72;
            this.setChanged();
        }
    }

    @Override
    protected void processFinish() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        DyeSqueezerRecipe finishedRecipe = this.currRecipe;
        this.red += finishedRecipe.getRed();
        this.yellow += finishedRecipe.getYellow();
        this.blue += finishedRecipe.getBlue();
        this.white += finishedRecipe.getWhite();
        this.red = Math.clamp((long)this.red, 0, (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get());
        this.yellow = Math.clamp((long)this.yellow, 0, (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get());
        this.blue = Math.clamp((long)this.blue, 0, (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get());
        this.white = Math.clamp((long)this.white, 0, (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get());
        this.stackInputHandler.extractItem(0, 1, false);
        this.generatePureFluid();
        this.setChanged();
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.stackInputHandler.getStackInSlot(0).isEmpty()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        return this.canStoreInternal(this.currRecipe);
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        return !this.stackInputHandler.getStackInSlot(0).isEmpty();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        this.currRecipe = (DyeSqueezerRecipe)((RecipeHolder)this.level.getRecipeManager().getRecipeFor((RecipeType)WootRecipes.DYE_SQUEEZER_TYPE.get(), (RecipeInput)new SingleRecipeInput(this.stackInputHandler.getStackInSlot(0)), this.level).get()).value();
    }

    private boolean canStoreInternal(DyeSqueezerRecipe recipe) {
        boolean whiteHasSpace;
        boolean redHasSpace = recipe.getRed() + this.red <= (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get();
        boolean yellowHasSpace = recipe.getYellow() + this.yellow <= (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get();
        boolean blueHasSpace = recipe.getBlue() + this.blue <= (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get();
        boolean bl = whiteHasSpace = recipe.getWhite() + this.white <= (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get();
        if (this.dumpExcess) {
            return recipe.getRed() > 0 && redHasSpace || recipe.getYellow() > 0 && yellowHasSpace || recipe.getBlue() > 0 && blueHasSpace || recipe.getWhite() > 0 && whiteHasSpace;
        }
        return redHasSpace && yellowHasSpace && blueHasSpace && whiteHasSpace;
    }

    private boolean canCreateOutput() {
        return this.red >= 72 && this.yellow >= 72 && this.blue >= 72 && this.white >= 72;
    }

    private boolean canStoreOutput() {
        return this.outputTank.internalFill(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 288), IFluidHandler.FluidAction.SIMULATE) == 288;
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(0).copy();
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.stackInputHandler.insertItem(0, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    public TankPacket getOutputTankPacket() {
        return new TankPacket(this.outputTank.getFluid(), 0);
    }

    public void toggleDumpExcess() {
        this.dumpExcess = !this.dumpExcess;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> SqueezerTileEntity");
        debug.add("      r:" + this.red + " y:" + this.yellow + " b:" + this.blue + " w:" + this.white);
        return debug;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new DyeSqueezerContainer(i, inventory, this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)SqueezerSetup.SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.energyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SqueezerSetup.SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.stackInputHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)SqueezerSetup.SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.fluidOutputHandler);
    }
}

