/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.crafting.dyesqueezer.DyeSqueezerRecipe;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerBlockEntity;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class DyeSqueezerContainer
extends WootContainer
implements TankPacketHandler {
    public DyeSqueezerBlockEntity tileEntity;
    public Player player;
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    private int progress = 0;
    private int energy = 0;
    private FluidStack pureDye = FluidStack.EMPTY;
    private boolean dumpExcess = false;

    public DyeSqueezerContainer(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public DyeSqueezerContainer(int windowId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)SqueezerSetup.SQUEEZER_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = (DyeSqueezerBlockEntity)entity;
        this.addOwnSlots((IItemHandler)this.tileEntity.stackInputHandler);
        this.addPlayerSlots(playerInventory);
        this.addListeners();
        this.player = playerInventory.player;
    }

    private void addOwnSlots(IItemHandler inv) {
        this.addSlot((Slot)new SlotItemHandler(inv, 0, 39, 40));
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 10 + col * 18;
                int y = row * 18 + 95;
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 10 + row * 18;
            this.addSlot(new Slot((Container)playerInventory, row, x, 153));
        }
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return DyeSqueezerContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)this.tileEntity.getBlockPos()), (Player)playerIn, (Block)((Block)SqueezerSetup.SQUEEZER_BLOCK.get()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        boolean MACHINE_INV_SIZE = true;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 1) {
            if (DyeSqueezerRecipe.isValidInput(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (index < 28) {
                startIndex = 28;
                endIndex = startIndex + 9;
            } else {
                if (index < 28) return ItemStack.EMPTY;
                startIndex = 1;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 1;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.moveItemStackTo(stack, startIndex, endIndex, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stack);
        return stackCopy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRedDyeAmount() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getYellowDyeAmount() {
        return this.yellow;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBlueDyeAmount() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWhiteDyeAmount() {
        return this.white;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getPureDye() {
        return this.pureDye;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergy() {
        return this.energy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getDumpExcess() {
        return this.dumpExcess;
    }

    public void addListeners() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getRed();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.red = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getBlue();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.blue = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getWhite();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.white = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getYellow();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.yellow = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getEnergy();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.energy = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getProgress();
            }

            public void set(int i) {
                DyeSqueezerContainer.this.progress = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DyeSqueezerContainer.this.tileEntity.getDumpExcess() ? 1 : 0;
            }

            public void set(int i) {
                DyeSqueezerContainer.this.dumpExcess = i == 1;
            }
        });
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.tileEntity.getLevel().isClientSide) {
            return;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.pureDye, (FluidStack)this.tileEntity.getOutputTankFluid()) || this.pureDye.getAmount() != this.tileEntity.getOutputTankFluid().getAmount()) {
            this.pureDye = this.tileEntity.getOutputTankFluid().copy();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)this.tileEntity.getOutputTankPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId() == 0) {
            this.pureDye = packet.fluidStack();
        }
    }
}

