/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.EnchantSqueezerMenu;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootMachineBlockEntity;
import ipsis.woot.util.helper.EnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class EnchantSqueezerBlockEntity
extends WootMachineBlockEntity
implements WootDebug,
MenuProvider {
    public static int INPUT_SLOT = 0;

    public EnchantSqueezerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK_TILE.get(), pos, blockState);
        this.stackInputHandler = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                EnchantSqueezerBlockEntity.this.onContentsChanged(slot);
                EnchantSqueezerBlockEntity.this.setChanged();
            }

            public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
                return EnchantmentHelper.isEnchanted(stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.fluidOutputHandler = new FluidTank(10000);
    }

    public void onLoad() {
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, WootMachineBlockEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (level.isClientSide) {
            return;
        }
        if (this.fluidOutputHandler.isEmpty()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            Optional<IFluidHandler> lazyOptional;
            BlockEntity te;
            if (this.settings.get(direction) != WootMachineBlockEntity.Mode.OUTPUT || (te = level.getBlockEntity(this.getBlockPos().offset(direction.getNormal()))) == null || !(lazyOptional = Optional.ofNullable((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)direction.getOpposite()))).isPresent()) continue;
            IFluidHandler iFluidHandler = lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = this.fluidOutputHandler.getFluid();
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.fluidOutputHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            this.setChanged();
        }
    }

    public FluidStack getOutputTankFluid() {
        return this.fluidOutputHandler.getFluid();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public IItemHandler getInventory() {
        return this.stackInputHandler;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot.enchsqueezer.name");
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyStorage.extractEnergy(((Integer)SqueezerConfiguration.ENCH_SQUEEZER_ENERGY_PER_TICK.get()).intValue(), false);
    }

    @Override
    protected int getRecipeEnergy() {
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return 0;
        }
        return this.getEnchantEnergy(itemStack);
    }

    @Override
    protected void clearRecipe() {
    }

    @Override
    protected void processFinish() {
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return;
        }
        this.stackInputHandler.extractItem(INPUT_SLOT, 1, false);
        int amount = this.getEnchantAmount(itemStack);
        this.fluidOutputHandler.fill(new FluidStack((Fluid)FluidSetup.ENCHANT_FLUID.get(), amount), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canStart() {
        int filled;
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return false;
        }
        if (!EnchantmentHelper.isEnchanted(itemStack) && !itemStack.is(Items.ENCHANTED_BOOK)) {
            return false;
        }
        int amount = this.getEnchantAmount(itemStack);
        return amount == (filled = this.fluidOutputHandler.fill(new FluidStack((Fluid)FluidSetup.ENCHANT_FLUID.get(), amount), IFluidHandler.FluidAction.SIMULATE));
    }

    @Override
    protected boolean hasValidInput() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)WootRecipes.ENCHANT_SQUEEZER_TYPE.get(), (RecipeInput)new SingleRecipeInput(this.stackInputHandler.getStackInSlot(INPUT_SLOT)), this.level).isPresent();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private int capEnchantAmount(int amount) {
        int max = SqueezerConfiguration.getEnchantFluidAmount(5);
        max *= 4;
        max = Math.clamp((long)max, 0, (Integer)SqueezerConfiguration.ENCH_SQUEEZER_TANK_CAPACITY.get());
        return Math.clamp((long)amount, 0, max);
    }

    private int getEnchantAmount(ItemStack itemStack) {
        AtomicInteger amount = new AtomicInteger();
        if (!itemStack.isEmpty() && (EnchantmentHelper.isEnchanted(itemStack) || itemStack.is(Items.ENCHANTED_BOOK))) {
            ItemEnchantments data = (ItemEnchantments)itemStack.get(DataComponents.STORED_ENCHANTMENTS);
            data.keySet().forEach(e -> amount.addAndGet(SqueezerConfiguration.getEnchantEnergy(data.getLevel(e))));
        }
        return this.capEnchantAmount(amount.get());
    }

    private int getEnchantEnergy(ItemStack itemStack) {
        AtomicInteger amount = new AtomicInteger();
        if (!itemStack.isEmpty() && (EnchantmentHelper.isEnchanted(itemStack) || itemStack.is(Items.ENCHANTED_BOOK))) {
            ItemEnchantments data = (ItemEnchantments)itemStack.get(DataComponents.STORED_ENCHANTMENTS);
            data.keySet().forEach(e -> amount.addAndGet(SqueezerConfiguration.getEnchantEnergy(data.getLevel(e))));
        }
        return amount.get();
    }

    public void dropContents(Level world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(INPUT_SLOT);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.stackInputHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> EnchantSqueezerTileEntity");
        debug.add("     p:" + this.fluidOutputHandler.getFluidAmount());
        debug.add("      Settings " + String.valueOf(this.settings));
        return debug;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory stackInputHandler, Player player) {
        return new EnchantSqueezerMenu(i, stackInputHandler, this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.energyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.stackInputHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK_TILE.get(), (be, side) -> be.fluidOutputHandler);
    }
}

