/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.client;

import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerContainer;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.RenderHelper;
import ipsis.woot.util.helper.StringHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DyeSqueezerScreen
extends WootContainerScreen<DyeSqueezerContainer> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/squeezer.png");
    private static final int GUI_XSIZE = 180;
    private static final int GUI_YSIZE = 177;
    private static final int ENERGY_LX = 10;
    private static final int ENERGY_LY = 18;
    private static final int ENERGY_RX = 25;
    private static final int ENERGY_RY = 77;
    private static final int ENERGY_WIDTH = 16;
    private static final int ENERGY_HEIGHT = 60;
    private static final int TANK_LX = 154;
    private static final int TANK_LY = 18;
    private static final int TANK_RX = 169;
    private static final int TANK_RY = 77;
    private static final int TANK_WIDTH = 16;
    private static final int TANK_HEIGHT = 60;
    private static final int X1 = 82;
    private static final int X1_length = 50;

    public DyeSqueezerScreen(DyeSqueezerContainer menu, Inventory playerInventory, Component name) {
        super(menu, playerInventory, name);
        this.imageWidth = 180;
        this.imageHeight = 177;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (RenderHelper.isPointInRegion(82, 30, 51, 8, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.woot.squeezer.red", (Object[])new Object[]{((DyeSqueezerContainer)this.menu).getRedDyeAmount(), SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()}), mouseX, mouseY);
        }
        if (RenderHelper.isPointInRegion(82, 40, 51, 8, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.woot.squeezer.yellow", (Object[])new Object[]{((DyeSqueezerContainer)this.menu).getYellowDyeAmount(), SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()}), mouseX, mouseY);
        }
        if (RenderHelper.isPointInRegion(82, 50, 51, 8, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.woot.squeezer.blue", (Object[])new Object[]{((DyeSqueezerContainer)this.menu).getBlueDyeAmount(), SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()}), mouseX, mouseY);
        }
        if (RenderHelper.isPointInRegion(82, 60, 51, 8, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.woot.squeezer.white", (Object[])new Object[]{((DyeSqueezerContainer)this.menu).getWhiteDyeAmount(), SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()}), mouseX, mouseY);
        }
        if (RenderHelper.isPointInRegion(154, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderFluidTankTooltip(guiGraphics, mouseX, mouseY, ((DyeSqueezerContainer)this.menu).getPureDye(), (Integer)SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get());
        }
        if (RenderHelper.isPointInRegion(10, 18, 16, 60, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop())) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, ((DyeSqueezerContainer)this.menu).getEnergy(), (Integer)SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY.get(), 10);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        String text2 = ((DyeSqueezerContainer)this.menu).getDumpExcess() ? StringHelper.translate("gui.woot.squeezer.dump") : StringHelper.translate("gui.woot.squeezer.strict");
        guiGraphics.drawString(this.font, text2, 82, 70, 0x404040);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((DyeSqueezerContainer)this.menu).getProgress();
        guiGraphics.blit(this.GUI, this.getGuiLeft() + 58, this.getGuiTop() + 30, 180, 0, (int)(19.0f * ((float)progress / 100.0f)), 40);
        this.renderHorizontalGauge(guiGraphics, 82, 30, 82 + (int)(50.0f * ((float)((DyeSqueezerContainer)this.menu).getRedDyeAmount() / (float)((Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()).intValue())), 38, 0xFF000000 | DyeColor.RED.getMapColor().col);
        this.renderHorizontalGauge(guiGraphics, 82, 40, 82 + (int)(50.0f * ((float)((DyeSqueezerContainer)this.menu).getYellowDyeAmount() / (float)((Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()).intValue())), 48, 0xFF000000 | DyeColor.YELLOW.getMapColor().col);
        this.renderHorizontalGauge(guiGraphics, 82, 50, 82 + (int)(50.0f * ((float)((DyeSqueezerContainer)this.menu).getBlueDyeAmount() / (float)((Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()).intValue())), 58, 0xFF000000 | DyeColor.BLUE.getMapColor().col);
        this.renderHorizontalGauge(guiGraphics, 82, 60, 82 + (int)(50.0f * ((float)((DyeSqueezerContainer)this.menu).getWhiteDyeAmount() / (float)((Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()).intValue())), 68, 0xFF000000 | DyeColor.WHITE.getMapColor().col);
        this.renderEnergyBar(guiGraphics, 10, 77, 60, 16, ((DyeSqueezerContainer)this.menu).getEnergy(), (Integer)SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY.get());
        this.renderFluidTank(guiGraphics, 154 + this.getGuiLeft(), 77 + this.getGuiTop(), 60, 16, (Integer)SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get(), ((DyeSqueezerContainer)this.menu).getPureDye());
    }
}

