/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.setup;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.config.OverrideLoader;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.mod.ModFiles;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.debug.DebugSetup;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.Cell1BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell2BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell3BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell4BlockEntity;
import ipsis.woot.modules.factory.blocks.ExporterBlockEntity;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.generators.LootGeneration;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import ipsis.woot.modules.fluidconvertor.blocks.FluidConvertorBlockEntity;
import ipsis.woot.modules.generic.GenericSetup;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.infuser.blocks.InfuserBlockEntity;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.modules.oracle.OracleSetup;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerBlockEntity;
import ipsis.woot.modules.squeezer.blocks.EnchantSqueezerBlockEntity;
import ipsis.woot.modules.tools.ToolsSetup;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.setup.WootCreativeModeTab;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.MobSimulatorSetup;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class ModSetup {
    private Logger logger = LogManager.getLogger();
    private CreativeModeTab creativeTab = new CreativeModeTab(this, CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)((HeartBlock)FactorySetup.HEART_BLOCK.get()).asItem())).title((Component)Component.literal((String)"woot"))){

        @NotNull
        public ItemStack getIconItem() {
            return new ItemStack((ItemLike)FactorySetup.HEART_BLOCK.get());
        }
    };

    public static void registrySetup(IEventBus eventBus) {
        InfuserSetup.register(eventBus);
        SqueezerSetup.register(eventBus);
        OracleSetup.register(eventBus);
        LayoutSetup.register(eventBus);
        AnvilSetup.register(eventBus);
        FluidSetup.register(eventBus);
        ToolsSetup.register(eventBus);
        DebugSetup.register(eventBus);
        GenericSetup.register(eventBus);
        FluidConvertorSetup.register(eventBus);
        FactorySetup.register(eventBus);
        WootCreativeModeTab.register(eventBus);
        WootRecipes.register(eventBus);
        MobSimulatorSetup.register(eventBus);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        EnchantSqueezerBlockEntity.registerCapabilities(event);
        DyeSqueezerBlockEntity.registerCapabilities(event);
        InfuserBlockEntity.registerCapabilities(event);
        FluidConvertorBlockEntity.registerCapabilities(event);
        Cell1BlockEntity.registerCapabilities(event);
        Cell2BlockEntity.registerCapabilities(event);
        Cell3BlockEntity.registerCapabilities(event);
        Cell4BlockEntity.registerCapabilities(event);
        ExporterBlockEntity.registerCapabilities(event);
    }

    public void commonSetup(FMLCommonSetupEvent e) {
        PolicyRegistry.get().loadFromConfig();
        ModFiles.INSTANCE.init();
        PatternRepository.get().load();
        OverrideLoader.loadFromConfig();
        PolicyRegistry.get().loadFromConfig();
        LootGeneration.get().loadFromConfig();
        File dropFile = ModFiles.INSTANCE.getLootFile();
        Gson GSON = new Gson();
        try {
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new FileReader(dropFile), JsonObject.class);
            MobSimulator.getInstance().fromJson(jsonObject);
        }
        catch (Exception exception) {
            Woot.setup.getLogger().warn("Failed to load loot file {}", (Object)dropFile.getAbsolutePath());
        }
    }

    public void clientSetup(FMLClientSetupEvent e) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CreativeModeTab getCreativeTab() {
        return this.creativeTab;
    }
}

