/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.setup;

import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.oracle.blocks.OracleTileEntity;
import ipsis.woot.modules.oracle.network.SimulatedMobDropsSummaryReply;
import ipsis.woot.modules.oracle.network.SimulatedMobsReply;
import ipsis.woot.simulator.MobSimulator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerDataRequest(String s, BlockPos pos, int requestType) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerDataRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerDataRequest::s, (StreamCodec)BlockPos.STREAM_CODEC, ServerDataRequest::pos, (StreamCodec)ByteBufCodecs.VAR_INT, ServerDataRequest::requestType, ServerDataRequest::new);
    public static final CustomPacketPayload.Type<ServerDataRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"datarequest"));

    public static void handle(ServerDataRequest request, IPayloadContext ctx) {
        Player serverPlayerEntity = ctx.player();
        ctx.enqueueWork(() -> {
            BlockEntity te = serverPlayerEntity.level().getBlockEntity(request.pos);
            switch (Type.fromIndex(request.requestType).ordinal()) {
                case 1: {
                    if (te instanceof OracleTileEntity) {
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)serverPlayerEntity), (CustomPacketPayload)new SimulatedMobsReply(MobSimulator.getInstance().getKnownMobs().stream().toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        break;
                    }
                }
                case 2: {
                    if (te instanceof OracleTileEntity) {
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)serverPlayerEntity), (CustomPacketPayload)SimulatedMobDropsSummaryReply.fromMob(request.s), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        break;
                    }
                }
                case 0: {
                    if (!(te instanceof HeartBlockEntity)) break;
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)serverPlayerEntity), (CustomPacketPayload)((HeartBlockEntity)te).createStaticDataReply2(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    @Override
    public String toString() {
        return this.requestType + " " + this.pos.toString() + "(" + this.s + ")";
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Type {
        HEART_STATIC_DATA,
        DROP_REGISTRY_STATUS,
        SIMULATED_MOB_DROPS;

        static Type[] VALUES;

        public static Type fromIndex(int index) {
            index = Math.clamp((long)index, 0, VALUES.length - 1);
            return VALUES[index];
        }

        static {
            VALUES = Type.values();
        }
    }
}

