/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator;

import com.mojang.serialization.MapCodec;
import ipsis.woot.simulator.tartarus.TartarusChunkGenerator;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MobSimulatorSetup {
    public static final DeferredRegister<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((ResourceKey)Registries.CHUNK_GENERATOR, (String)"woot");
    public static final DeferredHolder<MapCodec<? extends ChunkGenerator>, MapCodec<TartarusChunkGenerator>> MY_CHUNK_GENERATOR = CHUNK_GENERATORS.register("my_chunk_generator", () -> TartarusChunkGenerator.CODEC);
    public static final ResourceKey<DimensionType> TARTARUS_DIMENSION_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"mobsimulator"));
    public static final ResourceKey<LevelStem> TARTARUS = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"tartarus"));
    public static final ResourceKey<Level> TARTARUS_LEVEL_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"tartarus"));

    public static void register(IEventBus eventBus) {
        CHUNK_GENERATORS.register(eventBus);
    }

    public static void bootstrapType(BootstrapContext<DimensionType> context) {
        context.register(TARTARUS_DIMENSION_TYPE, (Object)new DimensionType(OptionalLong.of(12000L), false, false, false, false, 1.0, true, false, 0, 256, 256, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.OVERWORLD_EFFECTS, 0.0f, new DimensionType.MonsterSettings(true, false, (IntProvider)ConstantInt.of((int)0), 15)));
    }

    public static void bootstrapStem(BootstrapContext<LevelStem> context) {
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseGenSettings = context.lookup(Registries.NOISE_SETTINGS);
        TartarusChunkGenerator wrappedChunkGenerator = new TartarusChunkGenerator((BiomeSource)new FixedBiomeSource((Holder)biomeRegistry.getOrThrow(Biomes.OCEAN)), (Holder<NoiseGeneratorSettings>)noiseGenSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD));
        LevelStem stem = new LevelStem((Holder)dimTypes.getOrThrow(TARTARUS_DIMENSION_TYPE), (ChunkGenerator)wrappedChunkGenerator);
        context.register(TARTARUS, (Object)stem);
    }
}

