/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.Woot;
import ipsis.woot.modules.factory.generators.WoolGenerator;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.library.SimulatedMobDrop;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;

public class SimulatedMob {
    private FakeMob fakeMob;
    private int[] simulatedKills;
    private List<SimulatedMobDrop> simulatedMobDrops;
    private static final String TAG_MOB = "mob";
    private static final String TAG_SIM_KILLS = "simulatedKills";
    private static final String TAG_DROPS = "learnedDrops";

    private SimulatedMob() {
    }

    public SimulatedMob(FakeMob fakeMob) {
        this.fakeMob = fakeMob;
        this.simulatedKills = new int[]{0, 0, 0, 0};
        this.simulatedMobDrops = new ArrayList<SimulatedMobDrop>();
    }

    public FakeMob getFakeMob() {
        return this.fakeMob;
    }

    @Nonnull
    private SimulatedMobDrop getOrCreateSimulatedMobDrop(@Nonnull ItemStack itemStack) {
        SimulatedMobDrop simulatedMobDrop = null;
        for (SimulatedMobDrop d : this.simulatedMobDrops) {
            if (!MobSimulator.getInstance().isEqualForLearning(itemStack, d.itemStack)) continue;
            simulatedMobDrop = d;
            break;
        }
        return simulatedMobDrop == null ? new SimulatedMobDrop(itemStack, this) : simulatedMobDrop;
    }

    public void incrementSimulatedKills(int looting) {
        int n = looting = MathHelper.clampLooting(looting);
        this.simulatedKills[n] = this.simulatedKills[n] + 1;
    }

    public int getSimulatedKills(int looting) {
        return this.simulatedKills[MathHelper.clampLooting(looting)];
    }

    public void addSimulatedDrop(int looting, ItemStack itemStack) {
        if (itemStack.is(Tags.Items.TOOLS) && !itemStack.is(Items.TRIDENT) && !itemStack.is(Items.BOW)) {
            return;
        }
        if (itemStack.isEmpty() || itemStack.getCount() == 0) {
            return;
        }
        if (!PolicyRegistry.get().canLearnItem(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()))) {
            return;
        }
        SimulatedMobDrop simulatedMobDrop = this.getOrCreateSimulatedMobDrop(itemStack);
        if (!this.simulatedMobDrops.contains(simulatedMobDrop)) {
            this.simulatedMobDrops.add(simulatedMobDrop);
        }
        simulatedMobDrop.addSimulatedData(looting, itemStack.getCount());
    }

    public void addCustomDrop(int looting, @Nonnull ItemStack itemStack, float dropChance, HashMap<Integer, Integer> stackSizes) {
        if (itemStack.isEmpty()) {
            return;
        }
        SimulatedMobDrop simulatedMobDrop = this.getOrCreateSimulatedMobDrop(itemStack);
        if (!this.simulatedMobDrops.contains(simulatedMobDrop)) {
            this.simulatedMobDrops.add(simulatedMobDrop);
        }
        simulatedMobDrop.addCustomDrop(looting, dropChance, stackSizes);
    }

    @Nonnull
    public List<SimulatedMobDropSummary> getDropSummary() {
        ArrayList<SimulatedMobDropSummary> drops = new ArrayList<SimulatedMobDropSummary>();
        this.simulatedMobDrops.forEach(d -> drops.add(d.createSummary()));
        return drops;
    }

    @Nonnull
    public List<ItemStack> getRolledDrops(int looting) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        looting = MathHelper.clampLooting(looting);
        for (SimulatedMobDrop drop : this.simulatedMobDrops) {
            ItemStack itemStack = drop.getRolledDrop(looting);
            if (itemStack.isEmpty() || !PolicyRegistry.get().canGenerateItem(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()))) continue;
            drops.add(itemStack);
        }
        return drops;
    }

    public JsonObject toJson(FakeMob fakeMob) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(TAG_MOB, fakeMob.toString());
        JsonArray simKillsArray = new JsonArray();
        for (int i = 0; i < 4; ++i) {
            simKillsArray.add((Number)this.simulatedKills[i]);
        }
        jsonObject.add(TAG_SIM_KILLS, (JsonElement)simKillsArray);
        JsonArray dropsArray = new JsonArray();
        this.simulatedMobDrops.forEach(d -> {
            if (!d.hasCustom) {
                dropsArray.add((JsonElement)d.toJson());
            }
        });
        jsonObject.add(TAG_DROPS, (JsonElement)dropsArray);
        return jsonObject;
    }

    @Nullable
    public static SimulatedMob fromJson(JsonObject jsonObject) {
        String mob = jsonObject.get(TAG_MOB).getAsString();
        FakeMob fakeMob = new FakeMob(mob);
        if (!fakeMob.isValid()) {
            Woot.setup.getLogger().info("SimulatedMob:fromJson invalid mob {}", (Object)mob);
            return null;
        }
        if (!FakeMob.isInEntityList(fakeMob)) {
            Woot.setup.getLogger().info("SimulatedMob:fromJson mob not in entity list {}", (Object)mob);
            return null;
        }
        JsonArray killsArray = jsonObject.getAsJsonArray(TAG_SIM_KILLS);
        if (killsArray.size() != 4) {
            throw new JsonSyntaxException("Simulated kills array must be of size 4");
        }
        SimulatedMob simulatedMob = new SimulatedMob(fakeMob);
        for (int i = 0; i < 4; ++i) {
            simulatedMob.simulatedKills[i] = killsArray.get(i).getAsInt();
        }
        for (JsonElement jsonElement : jsonObject.getAsJsonArray(TAG_DROPS)) {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("Simulated drop must be an object");
            }
            SimulatedMobDrop simulatedMobDrop = SimulatedMobDrop.fromJson(simulatedMob, (JsonObject)jsonElement);
            if (simulatedMobDrop == null) continue;
            if (PolicyRegistry.get().canLearnItem(BuiltInRegistries.ITEM.getKey((Object)simulatedMobDrop.itemStack.getItem()))) {
                if (fakeMob.isSheep() && !WoolGenerator.isWoolDrop(simulatedMobDrop.itemStack)) {
                    simulatedMob.simulatedMobDrops.add(simulatedMobDrop);
                    continue;
                }
                simulatedMob.simulatedMobDrops.add(simulatedMobDrop);
                continue;
            }
            Woot.setup.getLogger().info("Drop {} is blacklisted", (Object)simulatedMobDrop.itemStack.getItem());
        }
        return simulatedMob;
    }
}

