/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.spawning;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.simulator.spawning.CustomSpawnController;
import ipsis.woot.simulator.spawning.FakePlayerPool;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.util.FakePlayer;

public class SpawnController {
    static SpawnController INSTANCE = new SpawnController();
    private static final int UNKNOWN_MOB_HEALTH = 100;
    private static final int UNKNOWN_MOB_EXP = 1;
    private static Map<String, MobCacheEntry> mobCacheEntryHashMap = new HashMap<String, MobCacheEntry>();

    public static SpawnController get() {
        return INSTANCE;
    }

    public void spawnKill(@Nonnull FakeMobKey fakeMobKey, @Nonnull ServerLevel world, @Nonnull BlockPos spawnPos) {
        if (!fakeMobKey.getMob().isValid()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer(world, fakeMobKey.getLooting());
        if (fakePlayer == null) {
            return;
        }
        Entity entity = this.createEntity(fakeMobKey.getMob(), (Level)world, spawnPos);
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mobEntity = (Mob)entity;
        mobEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(new BlockPos((Vec3i)entity.getOnPos())), MobSpawnType.SPAWNER, null);
        mobEntity.setLastHurtByPlayer((Player)fakePlayer);
        mobEntity.hurt(fakePlayer.damageSources().playerAttack((Player)fakePlayer), 100.0f);
        CustomSpawnController.get().apply(mobEntity, fakeMobKey.getMob(), (Level)world);
        mobEntity.hurt(fakePlayer.damageSources().playerAttack((Player)fakePlayer), Float.MAX_VALUE);
    }

    @Nullable
    private Entity createEntity(@Nonnull FakeMob fakeMob, @Nonnull Level world, @Nonnull BlockPos pos) {
        ResourceLocation rl = fakeMob.getResourceLocation();
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(rl)) {
            Woot.setup.getLogger().debug("createEntity: {} not in entity list", (Object)rl);
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", rl.toString());
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, xc -> {
            xc.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), xc.yRotO, xc.xRotO);
            return xc;
        });
        return entity;
    }

    public int getMobHealth(@Nonnull FakeMob fakeMob, @Nonnull Level level) {
        if (level.isClientSide) {
            return 100;
        }
        if (!fakeMob.isValid()) {
            return 100;
        }
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, level)) {
            return 100;
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.HEALTH)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.HEALTH);
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).health;
    }

    public int getMobExperience(@Nonnull FakeMob fakeMob, @Nonnull Level level) {
        if (level.isClientSide) {
            return 1;
        }
        if (!fakeMob.isValid()) {
            return 1;
        }
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, level)) {
            return 1;
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.XP)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.XP);
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).xp;
    }

    public boolean isAnimal(@Nonnull FakeMob fakeMob, @Nonnull Level world) {
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, world)) {
            return false;
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).isAnimal;
    }

    private boolean isCached(@Nonnull FakeMob fakeMob) {
        return mobCacheEntryHashMap.containsKey(fakeMob.toString());
    }

    private boolean updateCache(@Nonnull FakeMob fakeMob, @Nonnull Level world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        int health = (int)((LivingEntity)entity).getMaxHealth();
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((ServerLevel)world, 0);
        int xp = 1;
        xp = ((LivingEntity)entity).getExperienceReward((ServerLevel)entity.level(), (Entity)fakePlayer);
        Woot.setup.getLogger().debug("updateCache: caching mob:{} xp:{} health:{}", (Object)fakeMob, (Object)xp, (Object)health);
        this.addToCache(fakeMob, entity instanceof Animal, xp, health);
        return true;
    }

    public boolean isLivingEntity(FakeMob fakeMob, Level world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        return entity != null && entity instanceof Mob;
    }

    private void addToCache(FakeMob fakeMob, boolean isAnimal, int xp, int health) {
        mobCacheEntryHashMap.put(fakeMob.toString(), new MobCacheEntry(this, isAnimal, xp, health));
    }

    class MobCacheEntry {
        public boolean isAnimal = false;
        public int xp = 1;
        public int health = 1;

        public MobCacheEntry(SpawnController this$0, boolean isAnimal, int xp, int health) {
            this.isAnimal = isAnimal;
            this.xp = xp;
            this.health = health;
        }
    }
}

