/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.tartarus;

import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMobKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class Cell {
    private BlockPos origin;
    private BlockPos spawnPos;
    private AABB axisAlignedBB;
    private FakeMobKey fakeMobKey;

    public Cell(BlockPos origin) {
        this.origin = origin;
        this.spawnPos = origin.offset(4, 4, 4);
        this.fakeMobKey = null;
        this.axisAlignedBB = null;
    }

    public boolean isOccupied() {
        return this.fakeMobKey != null;
    }

    public void free() {
        this.fakeMobKey = null;
    }

    @Nullable
    public FakeMobKey getOccupant() {
        return this.fakeMobKey;
    }

    public boolean setMob(@Nonnull FakeMobKey fakeMobKey) {
        if (this.isOccupied()) {
            return false;
        }
        this.fakeMobKey = fakeMobKey;
        if (this.axisAlignedBB == null) {
            this.axisAlignedBB = new AABB(this.spawnPos).inflate(3.0);
        }
        return true;
    }

    public void clean(@Nonnull Level world) {
        for (LivingEntity livingEntity : world.getEntities(EntityTypeTest.forClass(LivingEntity.class), this.axisAlignedBB, Entity::isAlive)) {
            livingEntity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nonnull
    public List<ItemStack> sweep(@Nonnull Level world) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.isOccupied()) {
            for (ItemEntity itemEntity : world.getEntities(EntityTypeTest.forClass(ItemEntity.class), this.axisAlignedBB, Entity::isAlive)) {
                drops.add(itemEntity.getItem().copy());
                itemEntity.lifespan = 0;
            }
        }
        return drops;
    }

    public void run(@Nonnull Level world) {
        if (this.isOccupied() && world instanceof ServerLevel) {
            SpawnController.get().spawnKill(this.fakeMobKey, (ServerLevel)world, this.spawnPos);
        }
    }
}

