/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.tartarus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.Woot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class TartarusChunkGenerator
extends ChunkGenerator {
    public final Holder<NoiseGeneratorSettings> settings;
    public static final MapCodec<TartarusChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(i -> i.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(j -> j.settings)).apply((Applicative)inst, inst.stable(TartarusChunkGenerator::new)));
    public static final int WORK_CHUNK_X = 0;
    public static final int WORK_CHUNK_Z = 0;
    private List<BlockPos> cell0Blocks;
    private List<BlockPos> cell1Blocks;
    private List<BlockPos> cell2Blocks;
    private List<BlockPos> cell3Blocks;

    public TartarusChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource);
        this.settings = settings;
    }

    private void calcCellStructures() {
        if (this.cell1Blocks != null) {
            return;
        }
        ArrayList<BlockPos> fullBlocks = new ArrayList<BlockPos>(512);
        for (int x = 0; x < 8; ++x) {
            for (int z = 0; z < 8; ++z) {
                for (int y = 0; y < 8; ++y) {
                    fullBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        ArrayList<BlockPos> innerBlocks = new ArrayList<BlockPos>(512);
        for (int x = 1; x < 7; ++x) {
            for (int z = 1; z < 7; ++z) {
                for (int y = 1; y < 7; ++y) {
                    innerBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        this.cell0Blocks = new ArrayList<BlockPos>();
        for (BlockPos p : fullBlocks) {
            if (innerBlocks.contains(p)) continue;
            this.cell0Blocks.add(new BlockPos((Vec3i)p));
        }
        this.cell1Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell1Blocks.add(new BlockPos(p.getX() + 8, p.getY(), p.getZ()));
        }
        this.cell2Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell2Blocks.add(new BlockPos(p.getX() + 8, p.getY(), p.getZ() + 8));
        }
        this.cell3Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell3Blocks.add(new BlockPos(p.getX(), p.getY(), p.getZ() + 8));
        }
        fullBlocks = null;
        innerBlocks = null;
    }

    private void buildCell(ChunkAccess iChunk, List<BlockPos> posList, int y, BlockState blockState) {
        for (BlockPos pos : posList) {
            iChunk.setBlockState(new BlockPos(pos.getX(), pos.getY() + y, pos.getZ()), blockState, false);
        }
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion worldGenRegion, long l, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BlockState blockState = Blocks.AIR.defaultBlockState();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x1 = 0; x1 < 16; ++x1) {
            for (int z1 = 0; z1 < 16; ++z1) {
                for (int y1 = 0; y1 < 256; ++y1) {
                    chunkAccess.setBlockState((BlockPos)pos.set(x1, y1, z1), blockState, false);
                }
            }
        }
        if (chunkAccess.getPos().x == 0 && chunkAccess.getPos().z == 0) {
            Woot.setup.getLogger().debug("generateSurface: work chunk creating cells");
            BlockState wallState = Blocks.BEDROCK.defaultBlockState();
            this.calcCellStructures();
            for (int y = 0; y < 256; y += 8) {
                this.buildCell(chunkAccess, this.cell0Blocks, y, wallState);
                this.buildCell(chunkAccess, this.cell1Blocks, y, wallState);
                this.buildCell(chunkAccess, this.cell2Blocks, y, wallState);
                this.buildCell(chunkAccess, this.cell3Blocks, y, wallState);
            }
        }
    }

    public void spawnOriginalMobs(WorldGenRegion worldGenRegion) {
    }

    public int getGenDepth() {
        return 0;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(() -> {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos pos = new BlockPos(x, 0, z);
                    chunkAccess.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                }
            }
            return chunkAccess;
        });
    }

    public int getSeaLevel() {
        return 0;
    }

    public int getMinY() {
        return 0;
    }

    public int getBaseHeight(int i, int i1, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return 0;
    }

    @NotNull
    public NoiseColumn getBaseColumn(int i, int i1, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        int minY = levelHeightAccessor.getMinBuildHeight();
        int maxY = levelHeightAccessor.getMaxBuildHeight();
        BlockState[] column = new BlockState[maxY - minY];
        for (int x = minY; x < maxY; ++x) {
            column[x - minY] = Blocks.AIR.defaultBlockState();
        }
        return new NoiseColumn(minY, column);
    }

    public void addDebugScreenInfo(List<String> list, RandomState randomState, BlockPos blockPos) {
    }

    public void createStructures(RegistryAccess registryAccess, ChunkGeneratorStructureState structureState, StructureManager structureManager, ChunkAccess chunk, StructureTemplateManager structureTemplateManager) {
    }
}

