/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.util.helper.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class EnchantingHelper {
    public static ItemStack addRandomBookEnchant(ItemStack itemStack, int level, RegistryAccess access) {
        if (itemStack.getItem() != Items.BOOK) {
            return new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        List<Object> enchantments = new ArrayList();
        for (int l = level; enchantments.isEmpty() && l >= 1; ++l) {
            List<EnchantmentInstance> list = EnchantingHelper.getEnchantsAtLevel(l, access);
            if (list.isEmpty()) continue;
            enchantments = list;
        }
        itemStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        if (!enchantments.isEmpty()) {
            EnchantmentInstance d = (EnchantmentInstance)WeightedRandom.getRandomItem((RandomSource)RandomHelper.RANDOM, enchantments).get();
            itemStack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)d);
        }
        return itemStack;
    }

    private static List<EnchantmentInstance> getEnchantsAtLevel(int level, RegistryAccess access) {
        ArrayList<EnchantmentInstance> list = new ArrayList<EnchantmentInstance>();
        Registry enchantmentRegistry = access.registryOrThrow(Registries.ENCHANTMENT);
        for (Enchantment enchantment : enchantmentRegistry) {
            if (level < enchantment.getMinLevel() || level > enchantment.getMaxLevel()) continue;
            list.add(new EnchantmentInstance(Holder.direct((Object)enchantment), level));
        }
        return list;
    }
}

