/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;

public class FakeMob {
    private static final String INVALID_ENTITY_KEY = "INVALID";
    private static final String EMPTY_TAG = "";
    private String entityKey;
    private String tag;
    private String name;
    public static final StreamCodec<RegistryFriendlyByteBuf, FakeMob> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, FakeMob::getEntityKey, (StreamCodec)ByteBufCodecs.STRING_UTF8, FakeMob::getTag, FakeMob::new);
    public static final Codec<FakeMob> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("entityKey").forGetter(FakeMob::getEntityKey), (App)Codec.STRING.fieldOf("tag").forGetter(FakeMob::getTag)).apply((Applicative)inst, FakeMob::new)));
    private static final String KEY_ENTITY = "keyEntity";
    private static final String KEY_TAG = "keyTag";
    private static final String CHARGED_TAG = "charged";
    private static final String SMALL_TAG = "small";
    private static final String LARGE_TAG = "large";
    private static final String CREEPER = "minecraft:creeper";
    private static final String SLIME = "minecraft:slime";
    private static final String MAGMA_CUBE = "minecraft:magma_cube";
    private static final String ENDER_DRAGON = "minecraft:ender_dragon";
    private static final String WITHER = "minecraft:wither";
    private static final String SHEEP = "minecraft:sheep";
    private static final String SKELETON = "minecraft:skeleton";
    private static final String WITHER_SKELETON = "minecraft:wither_skeleton";
    private static final String ZOMBIE = "minecraft:zombie";

    public FakeMob() {
        this(INVALID_ENTITY_KEY, EMPTY_TAG);
    }

    public FakeMob(String s) {
        this();
        String[] parts = s.split(Pattern.quote(","));
        if (parts.length == 1) {
            this.setInfo(s, EMPTY_TAG);
        } else if (parts.length == 2) {
            this.setInfo(parts[0], parts[1]);
        }
    }

    private FakeMob(String entityKey, String tag) {
        this.setInfo(entityKey, tag);
    }

    public FakeMob(FakeMob fakeMob) {
        this(fakeMob.getEntityKey(), fakeMob.getTag());
    }

    public boolean equals(FakeMob other) {
        return this.entityKey.equals(other.entityKey);
    }

    public FakeMob(Mob mobEntity) {
        this();
        String entKey = EntityType.getKey((EntityType)mobEntity.getType()).toString();
        if (this.isSlime(mobEntity)) {
            if (((Slime)mobEntity).getSize() == 1) {
                this.setInfo(entKey, SMALL_TAG);
            } else {
                this.setInfo(entKey, LARGE_TAG);
            }
        } else if (this.isMagmaCube(mobEntity)) {
            if (((MagmaCube)mobEntity).getSize() == 1) {
                this.setInfo(entKey, SMALL_TAG);
            } else {
                this.setInfo(entKey, LARGE_TAG);
            }
        } else if (this.isChargedCreeper(mobEntity)) {
            this.setInfo(entKey, CHARGED_TAG);
        } else {
            this.setInfo(entKey, EMPTY_TAG);
        }
    }

    private void setInfo(String entityKey, String tag) {
        this.entityKey = entityKey;
        this.tag = tag;
        this.name = entityKey;
        if (!this.tag.equalsIgnoreCase(EMPTY_TAG)) {
            this.name = this.name + "," + this.tag;
        }
    }

    public String toString() {
        return this.name;
    }

    private String getEntityKey() {
        return this.entityKey;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTag() {
        return !this.tag.equalsIgnoreCase(EMPTY_TAG);
    }

    @Nonnull
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.parse((String)this.entityKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeMob fakeMob = (FakeMob)o;
        return this.entityKey.equalsIgnoreCase(fakeMob.entityKey) && this.tag.equalsIgnoreCase(fakeMob.tag) && this.name.equalsIgnoreCase(fakeMob.name);
    }

    public int hashCode() {
        return Objects.hash(this.entityKey, this.tag, this.name);
    }

    public boolean isValid() {
        return !this.entityKey.equalsIgnoreCase(INVALID_ENTITY_KEY);
    }

    public static boolean isInEntityList(FakeMob fakeMob) {
        return BuiltInRegistries.ENTITY_TYPE.containsKey(fakeMob.getResourceLocation());
    }

    public static void writeToNBT(@Nonnull FakeMob fakeMob, CompoundTag nbtTagCompound) {
        if (fakeMob.isValid()) {
            if (nbtTagCompound == null) {
                nbtTagCompound = new CompoundTag();
            }
            nbtTagCompound.putString(KEY_ENTITY, fakeMob.entityKey);
            nbtTagCompound.putString(KEY_TAG, fakeMob.tag);
        }
    }

    public FakeMob(CompoundTag nbtTagCompound) {
        this();
        if (nbtTagCompound != null && nbtTagCompound.contains(KEY_ENTITY) && nbtTagCompound.contains(KEY_TAG)) {
            this.setInfo(nbtTagCompound.getString(KEY_ENTITY), nbtTagCompound.getString(KEY_TAG));
        }
    }

    private boolean isChargedCreeper(Mob mobEntity) {
        return mobEntity instanceof Creeper && ((Creeper)mobEntity).isPowered();
    }

    private boolean isSlime(Mob mobEntity) {
        return mobEntity instanceof Slime;
    }

    private boolean isMagmaCube(Mob mobEntity) {
        return mobEntity instanceof MagmaCube;
    }

    public boolean isChargedCreeper() {
        return this.isCreeper() && this.tag.equalsIgnoreCase(CHARGED_TAG);
    }

    public boolean isSmallSlime() {
        return this.getEntityKey().equalsIgnoreCase(SLIME) && this.tag.equalsIgnoreCase(SMALL_TAG);
    }

    public boolean isSmallMagmaCube() {
        return this.getEntityKey().equalsIgnoreCase(MAGMA_CUBE) && this.tag.equalsIgnoreCase(SMALL_TAG);
    }

    public boolean isSheep() {
        return this.getEntityKey().equalsIgnoreCase(SHEEP);
    }

    public boolean isSkeleton() {
        return this.getEntityKey().equalsIgnoreCase(SKELETON);
    }

    public boolean isWitherSkeleton() {
        return this.getEntityKey().equalsIgnoreCase(WITHER_SKELETON);
    }

    public boolean isWither() {
        return this.getEntityKey().equalsIgnoreCase(WITHER);
    }

    public boolean isZombie() {
        return this.getEntityKey().equalsIgnoreCase(ZOMBIE);
    }

    public boolean isCreeper() {
        return this.getEntityKey().equalsIgnoreCase(CREEPER);
    }

    public static FakeMob getEnderDragon() {
        return new FakeMob(ENDER_DRAGON);
    }

    public static FakeMob getWither() {
        return new FakeMob(WITHER);
    }
}

