/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackHelper {
    public static FluidStack parse(@Nonnull JsonObject jsonObject) {
        ResourceLocation id = ResourceLocation.parse((String)GsonHelper.convertToString((JsonElement)jsonObject, (String)"fluid"));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
        return new FluidStack(fluid, GsonHelper.convertToInt((JsonElement)jsonObject, (String)"amount"));
    }

    public static JsonObject create(@Nonnull FluidStack fluidStack) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", fluidStack.getFluid().toString());
        jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
        return jsonObject;
    }

    public static FluidStack reduceByPercentage(FluidStack fluidStack, double p) {
        p = Math.clamp(p, 0.0, 100.0);
        Woot.setup.getLogger().debug("reduceByPercentage: {} @ {}%%", (Object)fluidStack.getAmount(), (Object)p);
        if (p == 0.0 || fluidStack.isEmpty()) {
            return fluidStack;
        }
        if (p == 100.0) {
            return FluidStack.EMPTY;
        }
        int reduction = (int)((double)((float)fluidStack.getAmount() / 100.0f) * p);
        int left = fluidStack.getAmount() - reduction;
        fluidStack.setAmount(left);
        return fluidStack;
    }
}

