/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class WootContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public WootContainerScreen(T menu, Inventory playerInventory, Component name) {
        super(menu, playerInventory, name);
    }

    public void renderEnergyBar(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int curr, int max) {
        int filled = 0;
        if (max > 0) {
            filled = curr * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        guiGraphics.fill(this.getGuiLeft() + x1, this.getGuiTop() + y1 - h + 1, this.getGuiLeft() + x1 + width, this.getGuiTop() + y1 + 1, -65536);
    }

    public void renderFluidTank(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int curr, int max, FluidStack fluidStack) {
        int filled = 0;
        if (max > 0) {
            filled = curr * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        this.drawFluid(guiGraphics, x1, y1 - h + 1, fluidStack, width, h);
    }

    public void renderFluidTank(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int max, FluidStack fluidStack) {
        int filled = 0;
        if (max > 0) {
            filled = fluidStack.getAmount() * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        this.drawFluid(guiGraphics, x1, y1 - h + 1, fluidStack, width, h);
    }

    public void renderFluidTank(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int max, FluidStack fluidStack, int amount) {
        int filled = 0;
        if (max > 0) {
            filled = amount * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        this.drawFluid(guiGraphics, x1, y1 - h + 1, fluidStack, width, h);
    }

    public void renderHorizontalBar(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int curr, int max, int color) {
        int filled = 0;
        if (max > 0) {
            filled = curr * max / 100;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int l = filled * (x2 - x1) / 100;
        ScreenRectangle rect = this.getRectangle();
        guiGraphics.fill(rect.left() + x1, rect.top() + y2, rect.left() + x2 + l, rect.top() + y2, color);
    }

    public void renderHorizontalGauge(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        guiGraphics.fill(this.getGuiLeft() + x1, this.getGuiTop() + y1, this.getGuiLeft() + x2, this.getGuiTop() + y2, color);
    }

    public void renderFluidTankTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, FluidStack fluidStack, int capacity) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (!fluidStack.isEmpty()) {
            tooltip.add(fluidStack.getHoverName());
            tooltip.add(Component.literal((String)String.format("%d/%d mb", fluidStack.getAmount(), capacity)));
        } else {
            tooltip.add(Component.literal((String)String.format("0/%d mb", capacity)));
        }
        guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
    }

    public void renderEnergyTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int curr, int capacity, int rate) {
        List<Component> tooltip = Arrays.asList(Component.literal((String)String.format("%d/%d RF", curr, capacity)), Component.literal((String)String.format("%d RF/tick", rate)));
        guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
    }

    public void drawFluid(GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int width, int height) {
        if (fluidStack.getFluid() == Fluids.EMPTY) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation sprite = clientFluid.getStillTexture(fluidStack);
        ResourceLocation sprite_flowing = clientFluid.getFlowingTexture(fluidStack);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sprite);
        int color = clientFluid.getTintColor();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        this.drawTiledTexture(guiGraphics, x, y, fluidTexture, width, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager._clearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private void drawTiledTexture(GuiGraphics guiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(guiGraphics, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
    }

    public void drawScaledTexturedModelRectFromIcon(GuiGraphics guiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.getU0();
        float maxU = icon.getU1();
        float minV = icon.getV0();
        float maxV = icon.getV1();
        float u1 = minU + (maxU - minU) * (float)width / 16.0f;
        float v1 = minV + (maxV - minV) * (float)height / 16.0f;
        guiGraphics.blit(x, y, 0, width, height, icon);
    }
}

