/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.util.WootEnergyStorage;
import ipsis.woot.util.helper.WorldHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WootMachineBlockEntity
extends BlockEntity {
    protected HashMap<Direction, Mode> settings = new HashMap();
    protected static final Logger LOGGER = LogManager.getLogger();
    public IEnergyStorage energyStorage = new WootEnergyStorage(10000);
    public ItemStackHandler stackInputHandler = new ItemStackHandler();
    public ItemStackHandler stackOutputHandler = new ItemStackHandler();
    public FluidTank fluidInputHandler = new FluidTank(10000);
    public FluidTank fluidOutputHandler = new FluidTank(10000);
    private boolean isActive = false;
    private int processMax = 0;
    private int processRem = 0;

    public WootMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FactorySetup.WOOT_MACHINE_ENTITY.get(), pos, state);
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, Mode.NONE);
        }
    }

    public WootMachineBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, Mode.NONE);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("Energy", this.energyStorage.getEnergyStored());
        tag.put("InputInventory", (Tag)this.stackInputHandler.serializeNBT(registries));
        tag.put("OutputInventory", (Tag)this.stackOutputHandler.serializeNBT(registries));
        tag.put("InputTank", (Tag)this.fluidInputHandler.writeToNBT(registries, new CompoundTag()));
        tag.put("OutputTank", (Tag)this.fluidOutputHandler.writeToNBT(registries, new CompoundTag()));
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("Energy")) {
            this.energyStorage = new WootEnergyStorage(10000, 1000, 1000, tag.getInt("Energy"));
        }
        if (tag.contains("InputInventory")) {
            this.stackInputHandler.deserializeNBT(registries, tag.getCompound("InputInventory"));
        }
        if (tag.contains("OutputInventory")) {
            this.stackOutputHandler.deserializeNBT(registries, tag.getCompound("OutputInventory"));
        }
        if (tag.contains("InputTank")) {
            this.fluidInputHandler.readFromNBT(registries, tag.getCompound("InputTank"));
        }
        if (tag.contains("OutputTank")) {
            this.fluidOutputHandler.readFromNBT(registries, tag.getCompound("OutputTank"));
        }
        super.loadAdditional(tag, registries);
    }

    public void tick(Level level) {
        if (level.isClientSide) {
            return;
        }
        this.machineTick();
    }

    private void machineTick() {
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                this.processFinish();
                if (this.isDisabled() || !this.canStart()) {
                    this.processOff();
                    this.isActive = false;
                } else {
                    this.processStart();
                }
            } else if (!this.hasEnergy()) {
                this.processOff();
            }
        } else if (!this.isDisabled() && this.canStart()) {
            this.processStart();
            this.processTick();
            this.isActive = true;
        }
    }

    protected boolean canStart() {
        return false;
    }

    protected void processFinish() {
    }

    protected boolean hasValidInput() {
        return false;
    }

    protected boolean hasEnergy() {
        return false;
    }

    protected int useEnergy() {
        return 0;
    }

    protected void clearRecipe() {
    }

    protected int getRecipeEnergy() {
        return 0;
    }

    protected boolean isDisabled() {
        return false;
    }

    private int processTick() {
        if (this.processRem <= 0) {
            return 0;
        }
        int energy = this.useEnergy();
        this.processRem -= energy;
        return energy;
    }

    private boolean canFinish() {
        return this.processRem <= 0 && this.hasValidInput();
    }

    protected int calculateProgress() {
        return this.processMax == 0 ? 0 : 100 - (int)(100.0f / (float)this.processMax * (float)this.processRem);
    }

    protected void processOff() {
        this.isActive = false;
        this.processRem = 0;
        this.processMax = 0;
        this.clearRecipe();
    }

    private void processStart() {
        this.processMax = this.getRecipeEnergy();
        this.processRem = this.getRecipeEnergy();
    }

    public void onContentsChanged(int slot) {
        if (!this.isActive) {
            return;
        }
        if (!this.hasValidInput()) {
            this.processOff();
        }
    }

    public void dropContents(List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            if (itemStack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)itemStack);
        }
        this.setChanged();
        WorldHelper.updateClient(this.level, this.getBlockPos());
    }

    protected static enum Mode {
        NONE,
        INPUT,
        OUTPUT;

    }
}

