/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderHelper {
    public static void drawTexturedCube(PoseStack poseStack, TextureAtlasSprite texture, float size) {
        if (texture == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.atlasLocation());
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder worldRenderer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float minU = texture.getU0();
        float maxU = texture.getU1();
        float minV = texture.getV0();
        float maxV = texture.getV1();
        Matrix4f matrix = poseStack.last().pose();
        worldRenderer.addVertex(matrix, -size, -size, size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, size, -size, size).setUv(minU, maxV);
        worldRenderer.addVertex(matrix, size, size, size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, -size, size, size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, -size, -size, -size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, -size, size, -size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, size, size, -size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, size, -size, -size).setUv(minU, maxV);
        worldRenderer.addVertex(matrix, -size, -size, -size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, -size, -size, size).setUv(minU, maxV);
        worldRenderer.addVertex(matrix, -size, size, size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, -size, size, -size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, size, -size, -size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, size, size, -size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, size, size, size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, size, -size, size).setUv(minU, maxV);
        worldRenderer.addVertex(matrix, -size, size, -size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, -size, size, size).setUv(minU, maxV);
        worldRenderer.addVertex(matrix, size, size, size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, size, size, -size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, -size, -size, -size).setUv(minU, minV);
        worldRenderer.addVertex(matrix, size, -size, -size).setUv(maxU, minV);
        worldRenderer.addVertex(matrix, size, -size, size).setUv(maxU, maxV);
        worldRenderer.addVertex(matrix, -size, -size, size).setUv(minU, maxV);
        worldRenderer.build();
    }

    public static boolean isPointInRegion(int regionX, int regionY, int regionWidth, int regionHeight, double mouseX, double mouseY, int leftPos, int topPos) {
        int relMouseX = (int)(mouseX - (double)leftPos);
        int relMouseY = (int)(mouseY - (double)topPos);
        return relMouseX >= regionX && relMouseX < regionX + regionWidth && relMouseY >= regionY && relMouseY < regionY + regionHeight;
    }

    public static void drawShadedCube(PoseStack poseStack, TextureAtlasSprite texture, float size) {
        if (texture == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.atlasLocation());
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder worldRenderer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float minU = texture.getU0();
        float maxU = texture.getU1();
        float minV = texture.getV0();
        float maxV = texture.getV1();
        Matrix4f matrix = poseStack.last().pose();
        worldRenderer.addVertex(matrix, -size, -size, size);
        worldRenderer.addVertex(matrix, size, -size, size);
        worldRenderer.addVertex(matrix, size, size, size);
        worldRenderer.addVertex(matrix, -size, size, size);
        worldRenderer.addVertex(matrix, -size, -size, -size);
        worldRenderer.addVertex(matrix, -size, size, -size);
        worldRenderer.addVertex(matrix, size, size, -size);
        worldRenderer.addVertex(matrix, size, -size, -size);
        worldRenderer.addVertex(matrix, -size, -size, -size);
        worldRenderer.addVertex(matrix, -size, -size, size);
        worldRenderer.addVertex(matrix, -size, size, size);
        worldRenderer.addVertex(matrix, -size, size, -size);
        worldRenderer.addVertex(matrix, size, -size, -size);
        worldRenderer.addVertex(matrix, size, size, -size);
        worldRenderer.addVertex(matrix, size, size, size);
        worldRenderer.addVertex(matrix, size, -size, size);
        worldRenderer.addVertex(matrix, -size, size, -size);
        worldRenderer.addVertex(matrix, -size, size, size);
        worldRenderer.addVertex(matrix, size, size, size);
        worldRenderer.addVertex(matrix, size, size, -size);
        worldRenderer.addVertex(matrix, -size, -size, -size);
        worldRenderer.addVertex(matrix, size, -size, -size);
        worldRenderer.addVertex(matrix, size, -size, size);
        worldRenderer.addVertex(matrix, -size, -size, size);
        worldRenderer.build();
    }
}

