/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.helper;

import ipsis.woot.Woot;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class SerializationHelper {
    public static String readJsonFile(File file) throws FileNotFoundException {
        StringBuilder jsonStringBuilder = new StringBuilder();
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                jsonStringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    jsonStringBuilder.append(line);
                }
            }
            catch (IOException exception) {
                if (exception instanceof FileNotFoundException) {
                    throw (FileNotFoundException)exception;
                }
                exception.printStackTrace();
            }
        }
        return jsonStringBuilder.toString();
    }

    public static void writeJsonFile(File file, String fileContents) {
        if (file != null) {
            file.getParentFile().mkdirs();
            File tempFile = new File(file.getAbsolutePath() + "_tmp");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
                bufferedWriter.write(fileContents);
                bufferedWriter.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            if (file.exists()) {
                file.delete();
            }
            if (file.exists()) {
                Woot.setup.getLogger().warn("Failed to delete " + String.valueOf(file));
            } else {
                tempFile.renameTo(file);
            }
        }
    }
}

