/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.helper;

import ipsis.woot.Woot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class StorageHelper {
    public static void insertItems(ItemStackHandler handler, List<Optional<IItemHandler>> hdlrs) {
        for (Optional<IItemHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.isEmpty()) continue;
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)itemStack.copy(), (boolean)false);
                    handler.setStackInSlot(i, remainder);
                }
            });
        }
    }

    public static void insertFluids(List<FluidStack> fluids, List<Optional<IFluidHandler>> hdlrs) {
        if (fluids.isEmpty() || hdlrs.isEmpty()) {
            return;
        }
        for (Optional<IFluidHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                int tanks = h.getTanks();
                if (tanks > 0) {
                    for (int tank = 0; tank < tanks; ++tank) {
                        FluidStack fluidStack = h.getFluidInTank(tank);
                        if (fluidStack == null || fluidStack.isEmpty()) continue;
                        for (FluidStack f : fluids) {
                            if (f.isEmpty() || !fluidStack.is(f.getFluid())) continue;
                            int filled = h.fill(f, IFluidHandler.FluidAction.EXECUTE);
                            Woot.setup.getLogger().debug("insertFluids: {} ----> topup {} {}", (Object)tank, (Object)f.getDescriptionId(), (Object)filled);
                            if (filled <= 0) continue;
                            f.setAmount(f.getAmount() - filled);
                        }
                    }
                }
            });
        }
        boolean haveFluids = false;
        for (FluidStack fluidStack : fluids) {
            if (fluidStack.isEmpty()) continue;
            haveFluids = true;
        }
        if (haveFluids) {
            for (Optional optional : hdlrs) {
                optional.ifPresent(h -> {
                    int tanks = h.getTanks();
                    if (tanks > 0) {
                        for (int tank = 0; tank < tanks; ++tank) {
                            FluidStack fluidStack = h.getFluidInTank(tank);
                            if (!fluidStack.isEmpty()) continue;
                            for (FluidStack f : fluids) {
                                if (f.isEmpty()) continue;
                                int filled = h.fill(f, IFluidHandler.FluidAction.EXECUTE);
                                Woot.setup.getLogger().debug("insertFluids: {} ----> new fill {} {}", (Object)tank, (Object)f.getDescriptionId(), (Object)filled);
                                if (filled <= 0) continue;
                                f.setAmount(f.getAmount() - filled);
                            }
                        }
                    }
                });
            }
        }
    }

    public static List<ItemStack> flattenItemStackList(List<ItemStack> items) {
        ArrayList<ItemStack> flattened = new ArrayList<ItemStack>();
        for (ItemStack itemStack : items) {
            for (ItemStack flatStack : flattened) {
                if (itemStack.isEmpty()) break;
                if (!ItemStack.isSameItemSameComponents((ItemStack)flatStack, (ItemStack)itemStack)) continue;
                flatStack.grow(itemStack.getCount());
                itemStack.setCount(0);
            }
            if (itemStack.isEmpty()) continue;
            flattened.add(itemStack.copy());
        }
        return flattened;
    }

    public static int getCount(ItemStack itemStack, List<Optional<IItemHandler>> hdlrs) {
        AtomicInteger count = new AtomicInteger();
        for (Optional<IItemHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int slot = 0; slot < h.getSlots(); ++slot) {
                    ItemStack slotStack = h.getStackInSlot(slot);
                    if (slotStack.isEmpty() || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                    count.getAndAdd(slotStack.getCount());
                }
            });
        }
        return count.get();
    }

    public static int getAmount(FluidStack fluidStack, List<Optional<IFluidHandler>> hdlrs) {
        AtomicInteger count = new AtomicInteger();
        for (Optional<IFluidHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int slot = 0; slot < h.getTanks(); ++slot) {
                    FluidStack slotStack = h.getFluidInTank(slot);
                    if (slotStack.isEmpty() || !FluidStack.isSameFluid((FluidStack)fluidStack, (FluidStack)slotStack)) continue;
                    count.getAndAdd(slotStack.getAmount());
                }
            });
        }
        return count.get();
    }
}

