/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.oss;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import ipsis.woot.util.oss.WootFakePlayer;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="woot")
public class WootFakePlayerFactory {
    private static Map<GameProfile, WootFakePlayer> fakePlayers = Maps.newHashMap();

    public static WootFakePlayer get(ServerLevel world, GameProfile username) {
        if (!fakePlayers.containsKey(username)) {
            WootFakePlayer fakePlayer = new WootFakePlayer(world, username);
            fakePlayers.put(username, fakePlayer);
        }
        return fakePlayers.get(username);
    }

    public static void unloadLevel(ServerLevel world) {
        fakePlayers.entrySet().removeIf(entry -> ((WootFakePlayer)((Object)((Object)entry.getValue()))).level() == world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDimensionUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            WootFakePlayerFactory.unloadLevel((ServerLevel)event.getLevel());
        }
    }
}

