/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.entity;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.danse.entity.StatuePlayerModelEntity;
import de.tomalbrc.danse.poly.PlayerPartHolder;
import de.tomalbrc.danse.registry.PlayerModelRegistry;
import de.tomalbrc.danse.util.Util;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class AnimatedPlayerModelEntity
extends StatuePlayerModelEntity
implements AnimatedEntity {
    public static final class_2960 ID = Util.id("player_model");
    protected static final String ANIMATION = "Animation";
    @Nullable
    protected String animation = null;

    public AnimatedPlayerModelEntity(class_1299<? extends StatuePlayerModelEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5875(true);
        this.field_5960 = true;
    }

    @Override
    public void setModel(Model model) {
        if (this.holder != null) {
            this.holder.destroy();
        }
        this.holder = new PlayerPartHolder<AnimatedPlayerModelEntity>(this, model);
        this.holder.setupHitbox();
        EntityAttachment.ofTicking((ElementHolder)this.holder, (class_1297)this);
    }

    @Override
    public void method_5749(class_11368 valueInput) {
        valueInput.method_71441(ANIMATION).ifPresent(anim -> {
            Model model;
            if (this.holder != null) {
                this.holder.destroy();
            }
            if (this.animation != null && !this.animation.isBlank() && this.holder != null) {
                this.holder.getAnimator().stopAnimation(this.animation);
            }
            this.animation = anim;
            if (!this.animation.isBlank() && (model = PlayerModelRegistry.getModel(this.animation)) != null && model.animations().containsKey((Object)this.animation)) {
                this.setModel(model);
                this.holder.getAnimator().playAnimation(this.animation, serverPlayer -> {
                    this.animation = null;
                });
            }
        });
        super.method_5749(valueInput);
        float yRot = valueInput.method_71423("Yaw", Float.NaN);
        if (!Float.isNaN(yRot)) {
            this.method_36456(yRot);
        }
    }

    @Override
    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        if (this.animation != null && !this.animation.isBlank()) {
            valueOutput.method_71469(ANIMATION, this.animation);
        }
        valueOutput.method_71464("Yaw", this.method_36454());
    }

    public void playAnimation(String animation, Consumer<class_3222> onFinish) {
        this.animation = animation;
        this.holder.getAnimator().playAnimation(animation, onFinish);
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        if (damageSource.method_5530()) {
            this.method_5768(serverLevel);
        }
        return damageSource.method_5530();
    }
}

