/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.util;

import de.tomalbrc.danse.Danse;
import de.tomalbrc.danse.registry.PlayerModelRegistry;
import de.tomalbrc.danse.util.Util;
import de.tomalbrc.dialogutils.DialogUtils;
import de.tomalbrc.dialogutils.util.ComponentAligner;
import de.tomalbrc.dialogutils.util.TextUtil;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.font.BitmapProvider;
import eu.pb4.polymer.resourcepack.extras.api.format.font.FontAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.font.FontProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.util.StringUtil;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11419;
import net.minecraft.class_11428;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class GestureDialog {
    public static class_11419 DIALOG;
    static byte[] DEFAULT_ICON;

    public static void add(boolean register, ResourcePackBuilder resourcePackBuilder, Runnable onFontCreated) {
        int columns = 3;
        int width = 240;
        ArrayList<class_11435> bodies = new ArrayList<class_11435>();
        ObjectArrayList dialogEntries = new ObjectArrayList();
        FontAsset.Builder fontAssetBuilder = FontAsset.builder();
        List<String> animations = PlayerModelRegistry.getAnimations();
        for (int i = 0; i < animations.size(); ++i) {
            String animation = animations.get(i);
            String name = animation + "_icon";
            byte[] iconStream = GestureDialog.getIcon(name);
            String entry = String.valueOf((char)(57345 + i));
            if (iconStream != null) {
                fontAssetBuilder.add((FontProvider.Builder)BitmapProvider.builder((class_2960)Util.id("font/" + name)).height(32).ascent(16).chars(entry));
                resourcePackBuilder.addData(AssetPaths.texture((class_2960)Util.id("font/" + name)), iconStream);
            }
            String iconStr = "<font:danse:gesture>" + entry + "</font>";
            String labelStr = StringUtil.capitalize((String)animation);
            dialogEntries.add(new DialogEntry(animation, iconStr, labelStr, width));
        }
        String d = fontAssetBuilder.build().toJson().replace("minecraft:", "");
        resourcePackBuilder.addData("assets/danse/font/gesture.json", d.getBytes(StandardCharsets.UTF_8));
        onFontCreated.run();
        class_5250 iconSpace = ComponentAligner.align((class_2561)class_2561.method_43470((String)" "), (TextUtil.Alignment)TextUtil.Alignment.CENTER, (int)((width - 33 * columns) / (columns * 2)));
        for (int i = 0; i < dialogEntries.size(); i += columns) {
            class_5250 line1 = class_2561.method_43473();
            class_5250 line2 = class_2561.method_43473();
            class_5250 spaceLine = class_2561.method_43473();
            for (int j = i; j < i + columns && j < dialogEntries.size(); ++j) {
                DialogEntry dialogEntry = (DialogEntry)dialogEntries.get(j);
                class_5250 iconCombined = GestureDialog.wrapCmd(dialogEntry.animation, class_2561.method_43473().method_10852((class_2561)iconSpace).method_10852(TextUtil.parse((String)dialogEntry.icon)).method_10852((class_2561)iconSpace));
                class_5250 labels = GestureDialog.wrapCmd(dialogEntry.animation, ComponentAligner.align((class_2561)TextUtil.parse((String)dialogEntry.text), (TextUtil.Alignment)TextUtil.Alignment.CENTER, (int)(width / columns)));
                line1.method_10852((class_2561)iconCombined);
                line2.method_10852((class_2561)labels);
                spaceLine.method_10852((class_2561)GestureDialog.wrapCmd(dialogEntry.animation, ComponentAligner.align((class_2561)ComponentAligner.spacer((int)8), (TextUtil.Alignment)TextUtil.Alignment.CENTER, (int)(width / columns))));
            }
            int c = dialogEntries.size() % 3;
            if (c != 0 && i / columns == columns) {
                class_2561 s = ComponentAligner.spacer((int)(width / columns));
                line1.method_10852(s);
                line2.method_10852(s);
                spaceLine.method_10852(s);
            }
            class_2561 parsed = ComponentAligner.defaultFont((class_2561)class_2561.method_43473().method_10852((class_2561)spaceLine).method_27693("\n").method_10852((class_2561)line1).method_27693("\n").method_10852((class_2561)spaceLine).method_10852((class_2561)spaceLine).method_27693("\n").method_10852((class_2561)line2));
            bodies.add(new class_11435(parsed, width));
        }
        class_11417 data = new class_11417((class_2561)class_2561.method_43470((String)"Gestures"), Optional.empty(), true, true, class_11520.field_60962, bodies, List.of());
        class_11519 btn = new class_11519(new class_11416((class_2561)class_2561.method_43470((String)"Close"), 150), Optional.empty());
        class_11428 dialog = new class_11428(data, btn);
        class_2960 dialogId = Util.id("gestures");
        if (register) {
            DialogUtils.registerDialog((class_2960)dialogId, (class_11419)dialog);
            DialogUtils.registerQuickDialog((class_2960)dialogId);
        }
        DIALOG = dialog;
    }

    private static class_5250 wrapCmd(String anim, class_5250 component) {
        class_2583 style = class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609("gesture " + anim)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)StringUtil.capitalize((String)anim))));
        return class_2561.method_43473().method_27696(style).method_10852((class_2561)component);
    }

    private static byte[] getIcon(String iconName) {
        InputStream is = Danse.class.getResourceAsStream("/model/danse/" + iconName + ".png");
        if (is != null) {
            try {
                return is.readAllBytes();
            }
            catch (IOException e) {
                return DEFAULT_ICON;
            }
        }
        Path f = FabricLoader.getInstance().getConfigDir().resolve("danse/" + iconName);
        File file = f.toFile();
        if (file.exists()) {
            byte[] byArray;
            FileInputStream stream = new FileInputStream(file);
            try {
                byArray = stream.readAllBytes();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return DEFAULT_ICON;
                }
            }
            stream.close();
            return byArray;
        }
        return DEFAULT_ICON;
    }

    static {
        try {
            DEFAULT_ICON = Objects.requireNonNull(Danse.class.getResourceAsStream("/model/danse/helicopter_icon.png")).readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private record DialogEntry(String animation, String icon, String text, int width) {
    }
}

