/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.bbmodel;

import com.google.common.collect.ImmutableMap;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import de.tomalbrc.bil.file.extra.ResourcePackModel;
import de.tomalbrc.bil.file.importer.AjBlueprintImporter;
import de.tomalbrc.danse.bbmodel.PerPixelModelGenerator;
import de.tomalbrc.danse.util.Util;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.joml.Vector3f;

public class PlayerModelImporter
extends AjBlueprintImporter {
    static Vector3f LIMB_SCALE = new Vector3f(0.46875f, 1.40625f, 0.46875f);
    static Vector3f LIMB_SCALE_SLIM = new Vector3f(0.3225f, 1.40625f, 0.46875f);

    public PlayerModelImporter(BbModel model) {
        super(model);
    }

    public static class_2960 addItemModel(String partName, Map<String, ResourcePackModel.DisplayTransform> transformMap) {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> {
            PlayerModelImporter.addPart(partName, transformMap, resourcePackBuilder);
            if (Util.isArm(partName)) {
                ImmutableMap displayMap = ImmutableMap.of((Object)"head", (Object)new ResourcePackModel.DisplayTransform(null, new Vector3f(0.9575f * (partName.equals("arm_r") ? 1.0f : -1.0f), 0.5f, 0.0f), LIMB_SCALE_SLIM));
                PlayerModelImporter.addPart(partName + "s", (Map<String, ResourcePackModel.DisplayTransform>)displayMap, resourcePackBuilder);
            }
        });
        return class_2960.method_60655((String)"danse", (String)partName);
    }

    protected class_2960 generateModel(BbOutliner outliner) {
        return switch (outliner.name) {
            case "head" -> this.generateModelPart(outliner, new Vector3f(0.0f, 5.9f, 0.0f), new Vector3f(0.9375f, 0.9375f, 0.9375f));
            case "body" -> this.generateModelPart(outliner, new Vector3f(0.0f, 8.5f, 0.0f), new Vector3f(0.9375f, 1.40625f, 0.46875f));
            case "arm_r" -> this.generateModelPart(outliner, new Vector3f(0.35f, 0.5f, 0.0f), LIMB_SCALE);
            case "arm_l" -> this.generateModelPart(outliner, new Vector3f(-0.35f, 0.5f, 0.0f), LIMB_SCALE);
            case "leg_r" -> this.generateModelPart(outliner, new Vector3f(0.125f, -1.74f, 0.0f), LIMB_SCALE);
            case "leg_l" -> this.generateModelPart(outliner, new Vector3f(-0.125f, -1.74f, 0.0f), LIMB_SCALE);
            default -> super.generateModel(outliner);
        };
    }

    protected class_2960 generateModelPart(BbOutliner outliner, Vector3f pos, Vector3f scale) {
        return PlayerModelImporter.addItemModel(outliner.name.toLowerCase(), (Map<String, ResourcePackModel.DisplayTransform>)ImmutableMap.of((Object)"head", (Object)new ResourcePackModel.DisplayTransform(null, pos, scale)));
    }

    private static void addPart(String partName, Map<String, ResourcePackModel.DisplayTransform> transformMap, ResourcePackBuilder resourcePackBuilder) {
        class_2382 size = Util.sizeFor(partName);
        Map<String, byte[]> dataMap = PerPixelModelGenerator.generatePerPixelModels(size.method_10263(), size.method_10264(), size.method_10260(), partName, transformMap);
        for (Map.Entry<String, byte[]> entry : dataMap.entrySet()) {
            resourcePackBuilder.addData(entry.getKey(), entry.getValue());
        }
    }

    protected Object2ObjectOpenHashMap<UUID, Node> makeNodeMap() {
        Object2ObjectOpenHashMap nodeMap = new Object2ObjectOpenHashMap();
        ObjectArraySet textures = new ObjectArraySet();
        textures.addAll((Collection)this.model.textures);
        for (BbOutliner.ChildEntry entry : this.model.outliner) {
            if (!entry.isNode()) continue;
            this.createBones(null, null, (Collection)this.model.outliner, nodeMap);
        }
        BbResourcePackGenerator.makeTextures((BbModel)this.model, textures.stream().filter(x -> x.name.equals("texture")).toList());
        return nodeMap;
    }
}

