/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.tomalbrc.danse.Danse;
import de.tomalbrc.danse.util.CacheKey;
import de.tomalbrc.danse.util.EquipmentAsset;
import de.tomalbrc.danse.util.MinecraftSkinFetcher;
import de.tomalbrc.danse.util.MinecraftSkinParser;
import de.tomalbrc.dialogutils.DialogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_10192;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class TextureCache {
    private static final Map<CacheKey, class_9280> ARMOR_CACHE = new ConcurrentHashMap<CacheKey, class_9280>();
    private static final Map<CacheKey, class_9280> TRIM_CACHE = new ConcurrentHashMap<CacheKey, class_9280>();
    private static List<Integer> PALETTE_KEY;

    public static void fetch(GameProfile profile, Consumer<BufferedImage> onFinish) {
        if (profile.getProperties().containsKey((Object)"textures")) {
            String textureBase64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).value();
            MinecraftSkinFetcher.fetchSkin(textureBase64, onFinish);
        } else {
            onFinish.accept(Danse.STEVE_TEXTURE);
        }
    }

    public static void fetch(String url, Consumer<BufferedImage> onFinish) {
        MinecraftSkinFetcher.fetchSkinFromURL(url, onFinish);
    }

    public static class_9280 armorCustomModelData(MinecraftSkinParser.BodyPart part, class_1799 itemStack, boolean inner) {
        String folder;
        EquipmentAsset.TextureEntry[] entries;
        if (!itemStack.method_57826(class_9334.field_54196)) {
            return class_9280.field_55212;
        }
        class_10192 eq = (class_10192)itemStack.method_58694(class_9334.field_54196);
        if (eq == null || eq.comp_3176().isEmpty()) {
            return class_9280.field_55212;
        }
        class_2960 loc = ((class_5321)eq.comp_3176().get()).method_29177();
        CacheKey key = new CacheKey(loc, part, inner);
        class_9280 cachedData = ARMOR_CACHE.get(key);
        if (cachedData != null) {
            class_9280 trimCmd = TextureCache.trim(part, itemStack, inner);
            if (cachedData != class_9280.field_55212 && trimCmd != class_9280.field_55212) {
                return TextureCache.merged(new class_9280(cachedData.comp_3354(), (List)new BooleanArrayList((Collection)cachedData.comp_3355()), cachedData.comp_3356(), (List)new IntArrayList((Collection)cachedData.comp_3357())), trimCmd);
            }
            return cachedData;
        }
        EquipmentAsset asset = TextureCache.loadEquipmentAsset(loc);
        if (asset == null) {
            return class_9280.field_55212;
        }
        if (!inner && asset.layers.humanoid != null && asset.layers.humanoid.length > 0) {
            entries = asset.layers.humanoid;
            folder = "humanoid";
        } else {
            entries = asset.layers.humanoidLeggings;
            folder = "humanoid_leggings";
        }
        if (entries == null || entries.length == 0 || entries[0].texture == null) {
            return class_9280.field_55212;
        }
        class_9280 trimCmd = TextureCache.trim(part, itemStack, inner);
        class_9280 result = null;
        class_9282 dyedColor = (class_9282)itemStack.method_58694(class_9334.field_49644);
        for (EquipmentAsset.TextureEntry entry : entries) {
            if (result == null) {
                result = TextureCache.loadArmorTextureData(part, entry, dyedColor, folder);
                continue;
            }
            TextureCache.merged(result, TextureCache.loadArmorTextureData(part, entry, dyedColor, folder));
        }
        if (!itemStack.method_31573(class_3489.field_48803)) {
            ARMOR_CACHE.put(key, result);
        }
        if (result != class_9280.field_55212 && trimCmd != class_9280.field_55212) {
            return TextureCache.merged(new class_9280(result.comp_3354(), (List)new BooleanArrayList((Collection)result.comp_3355()), result.comp_3356(), (List)new IntArrayList((Collection)result.comp_3357())), trimCmd);
        }
        return result;
    }

    private static EquipmentAsset loadEquipmentAsset(class_2960 loc) {
        EquipmentAsset equipmentAsset;
        String path = String.format("assets/%s/equipment/%s.json", loc.method_12836(), loc.method_12832());
        byte[] jsonBytes = DialogUtils.resourcePackBuilder().getDataOrSource(path);
        if (jsonBytes == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(jsonBytes), StandardCharsets.UTF_8);
        try {
            equipmentAsset = (EquipmentAsset)new Gson().fromJson((Reader)reader, EquipmentAsset.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse equipment JSON for " + String.valueOf(loc), e);
            }
        }
        reader.close();
        return equipmentAsset;
    }

    private static List<Integer> loadPaletteData(class_2960 id) {
        IntArrayList intArrayList;
        String pngPath = String.format("assets/%s/textures/trims/color_palettes/%s.png", id.method_12836(), id.method_12832());
        byte[] pngBytes = DialogUtils.resourcePackBuilder().getDataOrSource(pngPath);
        if (pngBytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pngBytes);
        try {
            IntArrayList colors = new IntArrayList();
            BufferedImage img = ImageIO.read(in);
            WritableRaster raster = img.getRaster();
            boolean grayscale = raster.getNumBands() == 1;
            for (int i = 0; i < img.getWidth(); ++i) {
                int r;
                if (grayscale) {
                    r = raster.getSample(i, 0, 0);
                    int rgba = 0xFF000000 | r << 16 | r << 8 | r;
                    colors.add(rgba);
                    continue;
                }
                r = raster.getSample(i, 0, 0);
                int g = raster.getSample(i, 0, 1);
                int b = raster.getSample(i, 0, 2);
                int rgba = 0xFF000000 | r << 16 | g << 8 | b;
                colors.add(rgba);
            }
            intArrayList = colors;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading PNG: " + pngPath, e);
            }
        }
        ((InputStream)in).close();
        return intArrayList;
    }

    private static class_9280 loadArmorTextureData(MinecraftSkinParser.BodyPart part, EquipmentAsset.TextureEntry textureEntry, class_9282 itemColor, String folder) {
        UnmodifiableIterator unmodifiableIterator;
        class_2960 id = class_2960.method_60654((String)textureEntry.texture);
        String pngPath = String.format("assets/%s/textures/entity/equipment/%s/%s.png", id.method_12836(), folder, id.method_12832());
        byte[] pngBytes = DialogUtils.resourcePackBuilder().getDataOrSource(pngPath);
        if (pngBytes == null) {
            return class_9280.field_55212;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pngBytes);
        try {
            BufferedImage img = ImageIO.read(in);
            ArrayList colors = new ArrayList();
            ArrayList alphas = new ArrayList();
            for (class_2350 dir : MinecraftSkinParser.DIRECTIONS) {
                MinecraftSkinParser.extractTextureRGB(img, MinecraftSkinParser.NOTCH_TEXTURE_MAP, part, MinecraftSkinParser.Layer.INNER, dir, data -> {
                    if (textureEntry.dyeable != null) {
                        int tint = textureEntry.dyeable.colorWhenUndyed;
                        if (itemColor != null) {
                            tint = itemColor.comp_2384();
                        }
                        colors.add(TextureCache.multiplyRGB(data.color(), tint));
                        alphas.add(data.alpha());
                    } else {
                        colors.add(data.color());
                        alphas.add(data.alpha());
                    }
                });
            }
            unmodifiableIterator = new class_9280((List)ImmutableList.of(), alphas, (List)ImmutableList.of(), colors);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading PNG: " + pngPath, e);
            }
        }
        ((InputStream)in).close();
        return unmodifiableIterator;
    }

    private static class_9280 loadTrimTextureData(MinecraftSkinParser.BodyPart part, class_2960 id, String folder) {
        UnmodifiableIterator unmodifiableIterator;
        String pngPath = String.format("assets/%s/textures/trims/entity/%s/%s.png", id.method_12836(), folder, id.method_12832());
        byte[] pngBytes = DialogUtils.resourcePackBuilder().getDataOrSource(pngPath);
        if (pngBytes == null) {
            return class_9280.field_55212;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pngBytes);
        try {
            BufferedImage img = ImageIO.read(in);
            IntArrayList colors = new IntArrayList();
            BooleanArrayList alphas = new BooleanArrayList();
            for (class_2350 dir : MinecraftSkinParser.DIRECTIONS) {
                MinecraftSkinParser.extractTextureRGB(img, MinecraftSkinParser.NOTCH_TEXTURE_MAP, part, MinecraftSkinParser.Layer.INNER, dir, arg_0 -> TextureCache.lambda$loadTrimTextureData$1((List)colors, (List)alphas, arg_0));
            }
            unmodifiableIterator = new class_9280((List)ImmutableList.of(), (List)alphas, (List)ImmutableList.of(), (List)colors);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading PNG: " + pngPath, e);
            }
        }
        ((InputStream)in).close();
        return unmodifiableIterator;
    }

    public static class_9280 trim(MinecraftSkinParser.BodyPart part, class_1799 itemStack, boolean inner) {
        if (!itemStack.method_57826(class_9334.field_49607)) {
            return class_9280.field_55212;
        }
        class_8053 trim = (class_8053)itemStack.method_58694(class_9334.field_49607);
        assert (trim != null);
        class_2960 materialId = class_2960.method_60654((String)trim.comp_3179().method_55840());
        class_2960 patternId = ((class_8056)trim.comp_3180().comp_349()).comp_1213();
        CacheKey key = new CacheKey(patternId, part, inner);
        class_9280 cachedData = TRIM_CACHE.get(key);
        if (cachedData != null) {
            return TextureCache.tinted(new class_9280(cachedData.comp_3354(), (List)new BooleanArrayList((Collection)cachedData.comp_3355()), cachedData.comp_3356(), (List)new IntArrayList((Collection)cachedData.comp_3357())), materialId);
        }
        if (PALETTE_KEY == null) {
            PALETTE_KEY = TextureCache.loadPaletteData(class_2960.method_60656((String)"trim_palette"));
        }
        String folder = inner ? "humanoid_leggings" : "humanoid";
        class_9280 data = TextureCache.loadTrimTextureData(part, patternId, folder);
        TRIM_CACHE.put(key, data);
        return TextureCache.tinted(new class_9280(data.comp_3354(), (List)new BooleanArrayList((Collection)data.comp_3355()), data.comp_3356(), (List)new IntArrayList((Collection)data.comp_3357())), materialId);
    }

    private static class_9280 tinted(class_9280 data, class_2960 materialId) {
        List<Integer> coloredPalette = TextureCache.loadPaletteData(materialId);
        if (coloredPalette != null) {
            for (int i = 0; i < data.comp_3357().size(); ++i) {
                Integer color;
                int paletteIndex;
                if (data.method_65365(i) != Boolean.TRUE || (paletteIndex = PALETTE_KEY.indexOf(color = data.method_65367(i))) == -1) continue;
                data.comp_3357().set(i, coloredPalette.get(paletteIndex));
            }
        }
        return data;
    }

    private static class_9280 merged(class_9280 texture, class_9280 overlay) {
        if (overlay != class_9280.field_55212) {
            for (int i = 0; i < texture.comp_3357().size(); ++i) {
                boolean visible;
                Integer armorColor = texture.method_65367(i);
                Integer trimColor = overlay.method_65367(i);
                Boolean armorVisible = texture.method_65365(i);
                Boolean trimVisible = overlay.method_65365(i);
                if (trimColor != null && trimVisible == Boolean.TRUE) {
                    texture.comp_3357().set(i, trimColor);
                } else {
                    texture.comp_3357().set(i, armorColor);
                }
                boolean bl = visible = armorVisible == Boolean.TRUE || trimVisible == Boolean.TRUE;
                if (!visible) continue;
                texture.comp_3355().set(i, true);
            }
        }
        return texture;
    }

    public static int multiplyRGB(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = r1 * r2 / 255;
        int g = g1 * g2 / 255;
        int b = b1 * b2 / 255;
        return r << 16 | g << 8 | b;
    }

    private static /* synthetic */ void lambda$loadTrimTextureData$1(List colors, List alphas, MinecraftSkinParser.ColorData data) {
        colors.add(data.color());
        alphas.add(data.alpha());
    }
}

