/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.danse.entity.GesturePlayerModelEntity;
import de.tomalbrc.danse.poly.GestureCameraHolder;
import de.tomalbrc.danse.registry.EntityRegistry;
import de.tomalbrc.danse.registry.PlayerModelRegistry;
import de.tomalbrc.danse.util.MinecraftSkinParser;
import de.tomalbrc.danse.util.TextureCache;
import de.tomalbrc.danse.util.Util;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2631;
import net.minecraft.class_2668;
import net.minecraft.class_2708;
import net.minecraft.class_2734;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3730;
import net.minecraft.class_8042;

public class GestureController {
    public static final Reference2ObjectOpenHashMap<UUID, GestureCameraHolder> GESTURE_CAMS = new Reference2ObjectOpenHashMap();

    public static void onConnect(class_3222 serverPlayer) {
        class_2631.method_59539((UUID)serverPlayer.method_5667()).thenAccept(gameProfile -> gameProfile.ifPresent(profile -> TextureCache.fetch(profile, image -> MinecraftSkinParser.calculate(image, x -> {}))));
    }

    public static void onDisconnect(class_3222 serverPlayer) {
        GestureCameraHolder cam = (GestureCameraHolder)((Object)GESTURE_CAMS.get((Object)serverPlayer.method_5667()));
        if (cam != null) {
            GestureController.onStop(cam);
        }
    }

    public static void onStop(class_3222 player) {
        GestureCameraHolder cam = (GestureCameraHolder)((Object)GESTURE_CAMS.get((Object)player.method_5667()));
        if (cam != null) {
            GestureController.onStop(cam);
        }
    }

    public static void onStop(GestureCameraHolder camera) {
        class_3222 player = camera.getPlayer();
        if (!player.method_14239()) {
            PolymerUtils.reloadInventory((class_3222)player);
            for (class_3244 watchingPlayer : camera.getPlayerModel().getHolder().getWatchingPlayers()) {
                watchingPlayer.method_14364((class_2596)new class_2744(player.method_5628(), Util.getEquipment((class_1309)player, false)));
            }
            ObjectArrayList data = new ObjectArrayList();
            data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((Byte)player.method_5841().method_12789(EntityTrackedData.FLAGS))));
            camera.getPlayerModel().getHolder().getWatchingPlayers().forEach(arg_0 -> GestureController.lambda$onStop$4(camera, player, (List)data, arg_0));
            class_10182 pmr = new class_10182(camera.getOrigin(), class_243.field_1353, player.method_36454() + player.method_5751(), player.method_36455());
            class_2708 packet = new class_2708(player.method_5628(), pmr, Set.of());
            class_10264 p2 = new class_10264(player.method_5628(), pmr, true);
            player.field_13987.method_14364((class_2596)new class_8042((Iterable)ImmutableList.of((Object)new class_2734((class_1297)player), (Object)VirtualEntityUtils.createRidePacket((int)camera.getCameraId(), (IntList)IntList.of()), (Object)new class_2668(class_2668.field_25648, (float)player.method_68876().method_8379()), (Object)packet, (Object)p2)));
        }
        camera.destroy();
        GESTURE_CAMS.remove((Object)player.method_5667());
    }

    public static void onStart(class_3222 player, String animationName) {
        TextureCache.fetch(player.method_7334(), image -> MinecraftSkinParser.calculate(image, dataMap -> {
            GestureCameraHolder camera = (GestureCameraHolder)((Object)((Object)((Object)GESTURE_CAMS.get((Object)player.method_5667()))));
            if (camera != null) {
                camera.destroy();
            }
            GesturePlayerModelEntity playerModel = (GesturePlayerModelEntity)EntityRegistry.GESTURE_PLAYER_MODEL.method_5883((class_1937)player.method_51469(), class_3730.field_16467);
            assert (playerModel != null);
            playerModel.setup(player, PlayerModelRegistry.getModel(animationName), (Map<MinecraftSkinParser.BodyPart, MinecraftSkinParser.PartData>)dataMap);
            playerModel.shouldCheckDistance(false);
            GestureCameraHolder gestureCameraHolder = new GestureCameraHolder(player, playerModel);
            GESTURE_CAMS.put((Object)player.method_5667(), (Object)gestureCameraHolder);
            ChunkAttachment.ofTicking((ElementHolder)gestureCameraHolder, (class_3218)player.method_51469(), (class_243)player.method_19538());
            playerModel.playAnimation(animationName, unused -> GestureController.onStop(gestureCameraHolder));
            player.method_51469().method_8649((class_1297)playerModel);
        }));
    }

    private static /* synthetic */ void lambda$onStop$4(GestureCameraHolder camera, class_3222 player, List data, class_3244 p) {
        camera.getPlayerModel().getHolder().sendPacketDirect(p, (class_2596)new class_2739(player.method_5628(), data));
    }
}

