/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.emotecraft;

import de.tomalbrc.bil.file.bbmodel.BbAnimation;
import de.tomalbrc.bil.file.bbmodel.BbAnimator;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.extra.easing.EasingType;
import de.tomalbrc.bil.file.extra.interpolation.Interpolation;
import de.tomalbrc.bil.json.CachedUuidDeserializer;
import de.tomalbrc.danse.emotecraft.EmotecraftAnimationFile;
import de.tomalbrc.danse.emotecraft.Move;
import de.tomalbrc.danse.emotecraft.PartTransformation;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;

public class EmoteConverter {
    private static final float TICKS_PER_SECOND = 20.0f;

    private static Map<String, UUID> BONE_UUIDS() {
        return Map.of("head", CachedUuidDeserializer.get((String)"fd7c0f39-b83e-d6fa-63ec-59ea1c8a668a"), "body", CachedUuidDeserializer.get((String)"2ad9f081-c775-ba36-359b-469065391598"), "leftArm", CachedUuidDeserializer.get((String)"787fcc9f-ba12-5313-1639-bdf9ba2e79cf"), "rightArm", CachedUuidDeserializer.get((String)"2c3db723-21d8-1f80-412e-e73c14ee4cb3"), "leftLeg", CachedUuidDeserializer.get((String)"27b11a0e-fd44-c101-1e12-6caa83bd474a"), "rightLeg", CachedUuidDeserializer.get((String)"628e82f7-9a35-9267-39cb-ebe43519a7e3"));
    }

    public static void convertAndAddTo(EmotecraftAnimationFile src, BbModel model) {
        ArrayList<Move> moves = new ArrayList<Move>(src.emote.moves);
        moves.sort(Comparator.comparingInt(m -> m.tick));
        HashMap<String, Map> bucket = new HashMap<String, Map>();
        for (Move m2 : moves) {
            int tick = m2.tick;
            String easing = m2.easing;
            for (String boneKey : EmoteConverter.BONE_UUIDS().keySet()) {
                PartTransformation pt;
                switch (boneKey) {
                    case "head": {
                        PartTransformation partTransformation = m2.head;
                        break;
                    }
                    case "body": {
                        PartTransformation partTransformation = m2.body;
                        break;
                    }
                    case "leftArm": {
                        PartTransformation partTransformation = m2.leftArm;
                        break;
                    }
                    case "rightArm": {
                        PartTransformation partTransformation = m2.rightArm;
                        break;
                    }
                    case "leftLeg": {
                        PartTransformation partTransformation = m2.leftLeg;
                        break;
                    }
                    case "rightLeg": {
                        PartTransformation partTransformation = m2.rightLeg;
                        break;
                    }
                    default: {
                        PartTransformation partTransformation = pt = null;
                    }
                }
                if (pt == null) continue;
                Combined c = bucket.computeIfAbsent(boneKey, k -> new TreeMap()).computeIfAbsent(tick, t -> new Combined());
                c.easing = easing;
                c.name = boneKey;
                if (pt.x != null) {
                    c.px = pt.x.floatValue();
                    c.hasPos = true;
                }
                if (pt.y != null) {
                    c.py = pt.y.floatValue();
                    c.hasPos = true;
                }
                if (pt.z != null) {
                    c.pz = pt.z.floatValue();
                    c.hasPos = true;
                }
                if (pt.pitch != null) {
                    c.rx = pt.pitch.floatValue();
                    c.hasRot = true;
                }
                if (pt.yaw != null) {
                    c.ry = pt.yaw.floatValue();
                    c.hasRot = true;
                }
                if (pt.roll == null) continue;
                c.rz = pt.roll.floatValue();
                c.hasRot = true;
            }
        }
        BbAnimation anim = new BbAnimation();
        anim.uuid = CachedUuidDeserializer.get((String)UUID.randomUUID().toString());
        anim.name = Optional.ofNullable(src.name).orElse("converted");
        anim.loop = src.emote.isLoop ? BbAnimation.LoopMode.LOOP : BbAnimation.LoopMode.ONCE;
        anim.override = true;
        anim.length = (float)(src.emote.stopTick - src.emote.beginTick) / 20.0f;
        anim.snapping = 0.05f;
        anim.startDelay = "0";
        anim.loopDelay = String.valueOf((float)src.emote.returnTick / 20.0f);
        anim.animators = new Object2ObjectArrayMap();
        for (Map.Entry entry : bucket.entrySet()) {
            String boneKey = (String)entry.getKey();
            UUID boneId = EmoteConverter.BONE_UUIDS().get(boneKey);
            Map byTick = (Map)entry.getValue();
            BbAnimator animator = anim.animators.computeIfAbsent(boneId, k -> {
                BbAnimator a = new BbAnimator();
                a.keyframes = new ObjectArrayList();
                return a;
            });
            for (Map.Entry entry2 : byTick.entrySet()) {
                float z;
                float y;
                float x;
                BbKeyframe kf;
                float time = (float)((Integer)entry2.getKey()).intValue() / 20.0f;
                Combined c = (Combined)entry2.getValue();
                if (c.hasPos) {
                    kf = EmoteConverter.makeKeyframe("position", time);
                    x = c.px;
                    y = c.py;
                    z = c.pz;
                    EmoteConverter.addDataPoint(kf, x, y, z);
                    animator.keyframes.add(kf);
                }
                if (!c.hasRot) continue;
                kf = EmoteConverter.makeKeyframe("rotation", time);
                x = (c.name.equals("body") ? -1.0f : 1.0f) * c.rx * 57.295776f;
                y = c.ry * 57.295776f;
                z = c.rz * 57.295776f;
                EmoteConverter.addDataPoint(kf, x, y, z);
                animator.keyframes.add(kf);
            }
        }
        model.animations.add((Object)anim);
    }

    private static BbKeyframe makeKeyframe(String channel, float time) {
        BbKeyframe kf = new BbKeyframe();
        kf.uuid = CachedUuidDeserializer.get((String)UUID.randomUUID().toString());
        kf.time = time;
        kf.channel = BbKeyframe.Channel.valueOf((String)channel.toUpperCase());
        kf.interpolation = Interpolation.LINEAR;
        kf.easing = EasingType.EASE_IN_OUT_QUAD;
        kf.dataPoints = new ObjectArrayList();
        return kf;
    }

    private static void addDataPoint(BbKeyframe kf, float x, float y, float z) {
        BbKeyframe.DataPointValue dx = new BbKeyframe.DataPointValue();
        dx.setValue(x);
        BbKeyframe.DataPointValue dy = new BbKeyframe.DataPointValue();
        dy.setValue(y);
        BbKeyframe.DataPointValue dz = new BbKeyframe.DataPointValue();
        dz.setValue(z);
        kf.dataPoints.add(Map.of("x", dx, "y", dy, "z", dz));
    }

    private static class Combined {
        String name;
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        float rx = 0.0f;
        float ry = 0.0f;
        float rz = 0.0f;
        String easing;
        boolean hasPos = false;
        boolean hasRot = false;

        private Combined() {
        }
    }
}

