/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.emotecraft;

import com.google.gson.JsonParseException;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.loader.AjBlueprintLoader;
import de.tomalbrc.bil.file.loader.ModelLoader;
import de.tomalbrc.danse.bbmodel.PlayerModelImporter;
import de.tomalbrc.danse.emotecraft.EmoteConverter;
import de.tomalbrc.danse.emotecraft.EmotecraftAnimationFile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

public class EmotecraftLoader
extends AjBlueprintLoader {
    List<EmotecraftAnimationFile> animationFiles = new ObjectArrayList();

    public void add(EmotecraftAnimationFile file) {
        this.animationFiles.add(file);
    }

    public Model load(InputStream input, String name) throws JsonParseException {
        Model model;
        InputStreamReader reader = new InputStreamReader(input);
        try {
            BbModel model2 = (BbModel)GSON.fromJson((Reader)reader, BbModel.class);
            if (name != null && !name.isEmpty()) {
                model2.modelIdentifier = name;
            }
            if (model2.modelIdentifier == null) {
                model2.modelIdentifier = model2.name;
            }
            model2.modelIdentifier = ModelLoader.normalizedModelId((String)model2.modelIdentifier);
            for (EmotecraftAnimationFile file : this.animationFiles) {
                EmoteConverter.convertAndAddTo(file, model2);
            }
            model = new PlayerModelImporter(model2).importModel();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new JsonParseException("Failed to parse: " + name, throwable3);
            }
        }
        ((Reader)reader).close();
        return model;
    }
}

