/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_1304;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_811;
import net.minecraft.class_9280;

public class MinecraftSkinParser {
    private static final int TEXTURE_WIDTH = 64;
    private static final int TEXTURE_HEIGHT = 64;
    public static final Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> NOTCH_TEXTURE_MAP = new EnumMap<BodyPart, Map<Layer, Map<class_2350, int[]>>>(BodyPart.class);
    public static final Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> CLASSIC_TEXTURE_MAP = new EnumMap<BodyPart, Map<Layer, Map<class_2350, int[]>>>(BodyPart.class);
    public static final Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> SLIM_TEXTURE_MAP = new EnumMap<BodyPart, Map<Layer, Map<class_2350, int[]>>>(BodyPart.class);
    private static final Map<BufferedImage, Map<BodyPart, PartData>> PARSED_CACHE = new ConcurrentHashMap<BufferedImage, Map<BodyPart, PartData>>();
    public static final ImmutableList<class_2350> DIRECTIONS = ImmutableList.of((Object)class_2350.field_11035, (Object)class_2350.field_11043, (Object)class_2350.field_11039, (Object)class_2350.field_11034, (Object)class_2350.field_11036, (Object)class_2350.field_11033);

    private static void defineNotchTextures(Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> classic, Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> notch) {
        notch.putAll(classic);
        EnumMap leftArmMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> leftArmInner = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmInner.put(class_2350.field_11043, new int[]{47, 20, -4, 12});
        leftArmInner.put(class_2350.field_11039, new int[]{43, 20, -4, 12});
        leftArmInner.put(class_2350.field_11035, new int[]{55, 20, -4, 12});
        leftArmInner.put(class_2350.field_11034, new int[]{51, 20, -4, 12});
        leftArmInner.put(class_2350.field_11036, new int[]{47, 16, -4, 4});
        leftArmInner.put(class_2350.field_11033, new int[]{51, 16, -4, 4});
        EnumMap<class_2350, int[]> leftArmOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmOuter.put(class_2350.field_11043, new int[]{47, 36, -4, 12});
        leftArmOuter.put(class_2350.field_11039, new int[]{43, 36, -4, 12});
        leftArmOuter.put(class_2350.field_11035, new int[]{55, 36, -4, 12});
        leftArmOuter.put(class_2350.field_11034, new int[]{51, 36, -4, 12});
        leftArmOuter.put(class_2350.field_11036, new int[]{47, 32, -4, 4});
        leftArmOuter.put(class_2350.field_11033, new int[]{51, 32, -4, 4});
        leftArmMap.put(Layer.INNER, leftArmInner);
        leftArmMap.put(Layer.OUTER, leftArmOuter);
        notch.put(BodyPart.LEFT_ARM, leftArmMap);
        EnumMap leftLegMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> leftLegInner = new EnumMap<class_2350, int[]>(class_2350.class);
        leftLegInner.put(class_2350.field_11043, new int[]{7, 20, -4, 12});
        leftLegInner.put(class_2350.field_11039, new int[]{3, 20, -4, 12});
        leftLegInner.put(class_2350.field_11035, new int[]{15, 20, -4, 12});
        leftLegInner.put(class_2350.field_11034, new int[]{11, 20, -4, 12});
        leftLegInner.put(class_2350.field_11036, new int[]{7, 16, -4, 4});
        leftLegInner.put(class_2350.field_11033, new int[]{11, 16, -4, 4});
        EnumMap<class_2350, int[]> leftLegOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        leftLegOuter.put(class_2350.field_11043, new int[]{7, 36, -4, 12});
        leftLegOuter.put(class_2350.field_11039, new int[]{3, 36, -4, 12});
        leftLegOuter.put(class_2350.field_11035, new int[]{15, 36, -4, 12});
        leftLegOuter.put(class_2350.field_11034, new int[]{11, 36, -4, 12});
        leftLegOuter.put(class_2350.field_11036, new int[]{7, 32, -4, 4});
        leftLegOuter.put(class_2350.field_11033, new int[]{11, 32, -4, 4});
        leftLegMap.put(Layer.INNER, leftLegInner);
        leftLegMap.put(Layer.OUTER, leftLegOuter);
        notch.put(BodyPart.LEFT_LEG, leftLegMap);
    }

    private static void defineAlexTextures(Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> classic, Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> slim) {
        slim.putAll(classic);
        EnumMap rightArmMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> rightArmInner = new EnumMap<class_2350, int[]>(class_2350.class);
        rightArmInner.put(class_2350.field_11034, new int[]{40, 20, 4, 12});
        rightArmInner.put(class_2350.field_11043, new int[]{44, 20, 3, 12});
        rightArmInner.put(class_2350.field_11039, new int[]{47, 20, 4, 12});
        rightArmInner.put(class_2350.field_11035, new int[]{51, 20, 3, 12});
        rightArmInner.put(class_2350.field_11036, new int[]{44, 16, 3, 4});
        rightArmInner.put(class_2350.field_11033, new int[]{47, 16, 3, 4});
        EnumMap<class_2350, int[]> rightArmOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        rightArmOuter.put(class_2350.field_11034, new int[]{40, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11043, new int[]{44, 36, 3, 12});
        rightArmOuter.put(class_2350.field_11039, new int[]{47, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11035, new int[]{51, 36, 3, 12});
        rightArmOuter.put(class_2350.field_11036, new int[]{44, 32, 3, 4});
        rightArmOuter.put(class_2350.field_11033, new int[]{47, 32, 3, 4});
        rightArmMap.put(Layer.INNER, rightArmInner);
        rightArmMap.put(Layer.OUTER, rightArmOuter);
        slim.put(BodyPart.RIGHT_ARM, rightArmMap);
        EnumMap leftArmMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> leftArmInner = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmInner.put(class_2350.field_11034, new int[]{32, 52, 4, 12});
        leftArmInner.put(class_2350.field_11043, new int[]{36, 52, 3, 12});
        leftArmInner.put(class_2350.field_11039, new int[]{39, 52, 4, 12});
        leftArmInner.put(class_2350.field_11035, new int[]{43, 52, 3, 12});
        leftArmInner.put(class_2350.field_11036, new int[]{36, 48, 3, 4});
        leftArmInner.put(class_2350.field_11033, new int[]{39, 48, 3, 4});
        EnumMap<class_2350, int[]> leftArmOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmOuter.put(class_2350.field_11034, new int[]{48, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11043, new int[]{52, 52, 3, 12});
        leftArmOuter.put(class_2350.field_11039, new int[]{55, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11035, new int[]{59, 52, 3, 12});
        leftArmOuter.put(class_2350.field_11036, new int[]{52, 48, 3, 4});
        leftArmOuter.put(class_2350.field_11033, new int[]{55, 48, 3, 4});
        leftArmMap.put(Layer.INNER, leftArmInner);
        leftArmMap.put(Layer.OUTER, leftArmOuter);
        slim.put(BodyPart.LEFT_ARM, leftArmMap);
    }

    private static void defineSteveTextures(Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> map) {
        EnumMap headMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> headInner = new EnumMap<class_2350, int[]>(class_2350.class);
        headInner.put(class_2350.field_11043, new int[]{8, 8, 8, 8});
        headInner.put(class_2350.field_11034, new int[]{0, 8, 8, 8});
        headInner.put(class_2350.field_11035, new int[]{24, 8, 8, 8});
        headInner.put(class_2350.field_11039, new int[]{16, 8, 8, 8});
        headInner.put(class_2350.field_11036, new int[]{8, 0, 8, 8});
        headInner.put(class_2350.field_11033, new int[]{16, 0, 8, 8});
        EnumMap<class_2350, int[]> headOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        headOuter.put(class_2350.field_11043, new int[]{40, 8, 8, 8});
        headOuter.put(class_2350.field_11034, new int[]{32, 8, 8, 8});
        headOuter.put(class_2350.field_11035, new int[]{56, 8, 8, 8});
        headOuter.put(class_2350.field_11039, new int[]{48, 8, 8, 8});
        headOuter.put(class_2350.field_11036, new int[]{40, 0, 8, 8});
        headOuter.put(class_2350.field_11033, new int[]{48, 0, 8, 8});
        headMap.put(Layer.INNER, headInner);
        headMap.put(Layer.OUTER, headOuter);
        map.put(BodyPart.HEAD, headMap);
        EnumMap bodyMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> bodyInner = new EnumMap<class_2350, int[]>(class_2350.class);
        bodyInner.put(class_2350.field_11043, new int[]{20, 20, 8, 12});
        bodyInner.put(class_2350.field_11034, new int[]{16, 20, 4, 12});
        bodyInner.put(class_2350.field_11035, new int[]{32, 20, 8, 12});
        bodyInner.put(class_2350.field_11039, new int[]{28, 20, 4, 12});
        bodyInner.put(class_2350.field_11036, new int[]{20, 16, 8, 4});
        bodyInner.put(class_2350.field_11033, new int[]{28, 16, 8, 4});
        EnumMap<class_2350, int[]> bodyOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        bodyOuter.put(class_2350.field_11043, new int[]{20, 36, 8, 12});
        bodyOuter.put(class_2350.field_11034, new int[]{16, 36, 4, 12});
        bodyOuter.put(class_2350.field_11035, new int[]{32, 36, 8, 12});
        bodyOuter.put(class_2350.field_11039, new int[]{28, 36, 4, 12});
        bodyOuter.put(class_2350.field_11036, new int[]{20, 32, 8, 4});
        bodyOuter.put(class_2350.field_11033, new int[]{28, 32, 8, 4});
        bodyMap.put(Layer.INNER, bodyInner);
        bodyMap.put(Layer.OUTER, bodyOuter);
        map.put(BodyPart.BODY, bodyMap);
        EnumMap rightArmMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> rightArmInner = new EnumMap<class_2350, int[]>(class_2350.class);
        rightArmInner.put(class_2350.field_11043, new int[]{44, 20, 4, 12});
        rightArmInner.put(class_2350.field_11034, new int[]{40, 20, 4, 12});
        rightArmInner.put(class_2350.field_11035, new int[]{52, 20, 4, 12});
        rightArmInner.put(class_2350.field_11039, new int[]{48, 20, 4, 12});
        rightArmInner.put(class_2350.field_11036, new int[]{44, 16, 4, 4});
        rightArmInner.put(class_2350.field_11033, new int[]{48, 16, 4, 4});
        EnumMap<class_2350, int[]> rightArmOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        rightArmOuter.put(class_2350.field_11043, new int[]{44, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11034, new int[]{40, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11035, new int[]{52, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11039, new int[]{48, 36, 4, 12});
        rightArmOuter.put(class_2350.field_11036, new int[]{44, 32, 4, 4});
        rightArmOuter.put(class_2350.field_11033, new int[]{48, 32, 4, 4});
        rightArmMap.put(Layer.INNER, rightArmInner);
        rightArmMap.put(Layer.OUTER, rightArmOuter);
        map.put(BodyPart.RIGHT_ARM, rightArmMap);
        EnumMap leftArmMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> leftArmInner = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmInner.put(class_2350.field_11043, new int[]{36, 52, 4, 12});
        leftArmInner.put(class_2350.field_11034, new int[]{32, 52, 4, 12});
        leftArmInner.put(class_2350.field_11035, new int[]{44, 52, 4, 12});
        leftArmInner.put(class_2350.field_11039, new int[]{40, 52, 4, 12});
        leftArmInner.put(class_2350.field_11036, new int[]{36, 48, 4, 4});
        leftArmInner.put(class_2350.field_11033, new int[]{40, 48, 4, 4});
        EnumMap<class_2350, int[]> leftArmOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        leftArmOuter.put(class_2350.field_11043, new int[]{52, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11034, new int[]{48, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11035, new int[]{60, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11039, new int[]{56, 52, 4, 12});
        leftArmOuter.put(class_2350.field_11036, new int[]{52, 48, 4, 4});
        leftArmOuter.put(class_2350.field_11033, new int[]{56, 48, 4, 4});
        leftArmMap.put(Layer.INNER, leftArmInner);
        leftArmMap.put(Layer.OUTER, leftArmOuter);
        map.put(BodyPart.LEFT_ARM, leftArmMap);
        EnumMap rightLegMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> rightLegInner = new EnumMap<class_2350, int[]>(class_2350.class);
        rightLegInner.put(class_2350.field_11043, new int[]{4, 20, 4, 12});
        rightLegInner.put(class_2350.field_11034, new int[]{0, 20, 4, 12});
        rightLegInner.put(class_2350.field_11035, new int[]{12, 20, 4, 12});
        rightLegInner.put(class_2350.field_11039, new int[]{8, 20, 4, 12});
        rightLegInner.put(class_2350.field_11036, new int[]{4, 16, 4, 4});
        rightLegInner.put(class_2350.field_11033, new int[]{8, 16, 4, 4});
        EnumMap<class_2350, int[]> rightLegOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        rightLegOuter.put(class_2350.field_11043, new int[]{4, 36, 4, 12});
        rightLegOuter.put(class_2350.field_11034, new int[]{0, 36, 4, 12});
        rightLegOuter.put(class_2350.field_11035, new int[]{12, 36, 4, 12});
        rightLegOuter.put(class_2350.field_11039, new int[]{8, 36, 4, 12});
        rightLegOuter.put(class_2350.field_11036, new int[]{4, 32, 4, 4});
        rightLegOuter.put(class_2350.field_11033, new int[]{8, 32, 4, 4});
        rightLegMap.put(Layer.INNER, rightLegInner);
        rightLegMap.put(Layer.OUTER, rightLegOuter);
        map.put(BodyPart.RIGHT_LEG, rightLegMap);
        EnumMap leftLegMap = new EnumMap(Layer.class);
        EnumMap<class_2350, int[]> leftLegInner = new EnumMap<class_2350, int[]>(class_2350.class);
        leftLegInner.put(class_2350.field_11043, new int[]{20, 52, 4, 12});
        leftLegInner.put(class_2350.field_11034, new int[]{16, 52, 4, 12});
        leftLegInner.put(class_2350.field_11035, new int[]{28, 52, 4, 12});
        leftLegInner.put(class_2350.field_11039, new int[]{24, 52, 4, 12});
        leftLegInner.put(class_2350.field_11036, new int[]{20, 48, 4, 4});
        leftLegInner.put(class_2350.field_11033, new int[]{24, 48, 4, 4});
        EnumMap<class_2350, int[]> leftLegOuter = new EnumMap<class_2350, int[]>(class_2350.class);
        leftLegOuter.put(class_2350.field_11043, new int[]{4, 52, 4, 12});
        leftLegOuter.put(class_2350.field_11034, new int[]{0, 52, 4, 12});
        leftLegOuter.put(class_2350.field_11035, new int[]{12, 52, 4, 12});
        leftLegOuter.put(class_2350.field_11039, new int[]{8, 52, 4, 12});
        leftLegOuter.put(class_2350.field_11036, new int[]{4, 48, 4, 4});
        leftLegOuter.put(class_2350.field_11033, new int[]{8, 48, 4, 4});
        leftLegMap.put(Layer.INNER, leftLegInner);
        leftLegMap.put(Layer.OUTER, leftLegOuter);
        map.put(BodyPart.LEFT_LEG, leftLegMap);
    }

    public static boolean isSlimSkin(BufferedImage image) {
        return image.getWidth() == 64 && image.getHeight() == 64 && image.getRGB(50, 16) == 0;
    }

    public static void extractTextureRGB(BufferedImage image, Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> textureMap, BodyPart part, Layer layer, class_2350 direction, Consumer<ColorData> consumer) {
        Map<Layer, Map<class_2350, int[]>> partMap = textureMap.get((Object)part);
        if (partMap == null) {
            return;
        }
        Map<class_2350, int[]> layerMap = partMap.get((Object)layer);
        if (layerMap == null) {
            return;
        }
        int[] region = layerMap.get(direction);
        if (region == null) {
            return;
        }
        int startX = region[0];
        int startY = region[1];
        int width = region[2];
        int height = region[3];
        switch (direction) {
            case field_11034: {
                MinecraftSkinParser.eastTex(image, consumer, width, height, startX, startY);
                break;
            }
            case field_11039: {
                MinecraftSkinParser.westTex(image, consumer, width, height, startX, startY);
                break;
            }
            case field_11036: {
                MinecraftSkinParser.upTex(image, consumer, height, width, startX, startY);
                break;
            }
            case field_11035: {
                MinecraftSkinParser.southTex(image, consumer, height, width, startX, startY);
                break;
            }
            case field_11043: 
            case field_11033: {
                MinecraftSkinParser.northTex(image, consumer, height, width, startX, startY);
            }
        }
    }

    public static void extractTextureRGB(BufferedImage image, BodyPart part, Layer layer, class_2350 direction, Consumer<ColorData> consumer) {
        boolean isSlim = MinecraftSkinParser.isSlimSkin(image);
        Map<BodyPart, Map<Layer, Map<class_2350, int[]>>> textureMap = isSlim ? SLIM_TEXTURE_MAP : (image.getHeight() > 32 ? CLASSIC_TEXTURE_MAP : NOTCH_TEXTURE_MAP);
        MinecraftSkinParser.extractTextureRGB(image, textureMap, part, layer, direction, consumer);
    }

    private static void eastTex(BufferedImage image, Consumer<ColorData> consumer, int width, int height, int startX, int startY) {
        for (int dx = 0; dx < class_3532.method_15382((int)width); ++dx) {
            for (int dy = height - 1; dy >= 0; --dy) {
                consumer.accept(MinecraftSkinParser.sample(image, startX, startY, dx * class_3532.method_17822((double)width), dy));
            }
        }
    }

    private static void westTex(BufferedImage image, Consumer<ColorData> consumer, int width, int height, int startX, int startY) {
        for (int dx = class_3532.method_15382((int)width) - 1; dx >= 0; --dx) {
            for (int dy = height - 1; dy >= 0; --dy) {
                consumer.accept(MinecraftSkinParser.sample(image, startX, startY, dx * class_3532.method_17822((double)width), dy));
            }
        }
    }

    private static void northTex(BufferedImage image, Consumer<ColorData> consumer, int height, int width, int startX, int startY) {
        for (int dy = height - 1; dy >= 0; --dy) {
            for (int dx = 0; dx < class_3532.method_15382((int)width); ++dx) {
                consumer.accept(MinecraftSkinParser.sample(image, startX, startY, dx * class_3532.method_17822((double)width), dy));
            }
        }
    }

    private static void upTex(BufferedImage image, Consumer<ColorData> consumer, int height, int width, int startX, int startY) {
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < class_3532.method_15382((int)width); ++dx) {
                consumer.accept(MinecraftSkinParser.sample(image, startX, startY, dx * class_3532.method_17822((double)width), dy));
            }
        }
    }

    private static void southTex(BufferedImage image, Consumer<ColorData> consumer, int height, int width, int startX, int startY) {
        for (int dy = height - 1; dy >= 0; --dy) {
            for (int dx = class_3532.method_15382((int)width) - 1; dx >= 0; --dx) {
                consumer.accept(MinecraftSkinParser.sample(image, startX, startY, dx * class_3532.method_17822((double)width), dy));
            }
        }
    }

    private static ColorData sample(BufferedImage image, int startX, int startY, int dx, int dy) {
        int y = startY + dy;
        int x = startX + dx;
        int rgb = image.getRGB(x, y);
        return new ColorData(rgb);
    }

    public static void calculate(BufferedImage image, Consumer<Map<BodyPart, PartData>> onFinish) {
        Map<BodyPart, PartData> cached = PARSED_CACHE.get(image);
        if (cached != null) {
            onFinish.accept(cached);
            return;
        }
        Object2ObjectArrayMap data = new Object2ObjectArrayMap();
        for (BodyPart part : BodyPart.values()) {
            ArrayList colors = new ArrayList();
            ArrayList alphas = new ArrayList();
            for (class_2350 direction : DIRECTIONS) {
                MinecraftSkinParser.extractTextureRGB(image, part, Layer.INNER, direction, colorData -> {
                    colors.add(colorData.color());
                    alphas.add(colorData.alpha());
                });
            }
            ArrayList colorsOuter = new ArrayList();
            ArrayList alphasOuter = new ArrayList();
            if (image.getHeight() > 32) {
                for (class_2350 direction : DIRECTIONS) {
                    MinecraftSkinParser.extractTextureRGB(image, part, Layer.OUTER, direction, colorData -> {
                        colorsOuter.add(colorData.color());
                        alphasOuter.add(colorData.alpha());
                    });
                }
            }
            class_9280 innerCmd = new class_9280((List)ImmutableList.of(), alphas, (List)ImmutableList.of(), colors);
            class_9280 outerCmd = new class_9280((List)ImmutableList.of(), alphasOuter, (List)ImmutableList.of(), colorsOuter);
            data.put(part, new PartData(innerCmd, outerCmd, MinecraftSkinParser.isSlimSkin(image)));
        }
        if (image != null) {
            PARSED_CACHE.put(image, (Map<BodyPart, PartData>)data);
        }
        onFinish.accept((Map<BodyPart, PartData>)data);
    }

    static {
        MinecraftSkinParser.defineSteveTextures(CLASSIC_TEXTURE_MAP);
        MinecraftSkinParser.defineNotchTextures(CLASSIC_TEXTURE_MAP, NOTCH_TEXTURE_MAP);
        MinecraftSkinParser.defineAlexTextures(CLASSIC_TEXTURE_MAP, SLIM_TEXTURE_MAP);
    }

    public static enum Layer {
        INNER,
        OUTER;

    }

    public static enum BodyPart {
        NONE("none", null, null),
        HEAD("head", class_1304.field_6169, class_811.field_4316),
        BODY("body", class_1304.field_6174, null),
        LEFT_ARM("arm_l", class_1304.field_6174, class_811.field_4323),
        RIGHT_ARM("arm_r", class_1304.field_6174, class_811.field_4320),
        LEFT_ARM_SLIM("arm_ls", class_1304.field_6174, class_811.field_4323),
        RIGHT_ARM_SLIM("arm_rs", class_1304.field_6174, class_811.field_4320),
        LEFT_LEG("leg_l", class_1304.field_6172, null),
        RIGHT_LEG("leg_r", class_1304.field_6172, null);

        private final String name;
        private final class_1304 slot;
        private final class_811 context;

        private BodyPart(String name, class_1304 slot, class_811 context) {
            this.name = name;
            this.slot = slot;
            this.context = context;
        }

        public class_811 getContext() {
            return this.context;
        }

        public String getName() {
            return this.name;
        }

        public class_1304 getSlot() {
            return this.slot;
        }

        public class_2960 modelId(boolean slim) {
            if (slim) {
                return class_2960.method_60655((String)"danse", (String)(this.getName() + "s"));
            }
            return class_2960.method_60655((String)"danse", (String)this.getName());
        }

        public boolean isArm() {
            return this == RIGHT_ARM || this == LEFT_ARM || this == RIGHT_ARM_SLIM || this == LEFT_ARM_SLIM;
        }

        public boolean isLeg() {
            return this == RIGHT_LEG || this == LEFT_LEG;
        }

        public static BodyPart partFrom(String partName) {
            return switch (partName) {
                case "head" -> HEAD;
                case "body" -> BODY;
                case "arm_r" -> RIGHT_ARM;
                case "arm_l" -> LEFT_ARM;
                case "arm_rs" -> RIGHT_ARM_SLIM;
                case "arm_ls" -> LEFT_ARM_SLIM;
                case "leg_l" -> LEFT_LEG;
                case "leg_r" -> RIGHT_LEG;
                default -> NONE;
            };
        }
    }

    public record ColorData(int color) {
        public boolean alpha() {
            return (this.color >> 24 & 0xFF) >= 240;
        }
    }

    public record PartData(class_9280 customModelDataInner, class_9280 customModelDataOuter, boolean slim) {
    }
}

