/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.danse.GestureController;
import de.tomalbrc.danse.ModConfig;
import de.tomalbrc.danse.bbmodel.PlayerModelLoader;
import de.tomalbrc.danse.command.GestureCommand;
import de.tomalbrc.danse.emotecraft.EmotecraftAnimationFile;
import de.tomalbrc.danse.emotecraft.EmotecraftLoader;
import de.tomalbrc.danse.poly.GestureCameraHolder;
import de.tomalbrc.danse.registry.EntityRegistry;
import de.tomalbrc.danse.registry.ItemRegistry;
import de.tomalbrc.danse.registry.PlayerModelRegistry;
import de.tomalbrc.danse.util.GestureDialog;
import de.tomalbrc.dialogutils.util.FontUtil;
import eu.pb4.polymer.autohost.impl.AutoHostConfig;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Danse
implements ModInitializer {
    public static final String MODID = "danse";
    public static ResourcePackBuilder RESOURCEPACK_BUILDER;
    public static Logger LOGGER;
    public static BufferedImage STEVE_TEXTURE;
    public static Int2IntArrayMap VIRTUAL_ENTITY_PICK_MAP;

    public void onInitialize() {
        PolymerResourcePackUtils.addModAssets((String)MODID);
        PolymerResourcePackUtils.markAsRequired();
        ModConfig.load();
        PlayerModelRegistry.loadBuiltin();
        this.loadAnimations();
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            if (!((AutoHostConfig)CommonImpl.loadConfig((String)"auto-host", AutoHostConfig.class)).enabled) {
                PolymerResourcePackMod.generateAndCall((MinecraftServer)minecraftServer, (boolean)true, arg_0 -> ((MinecraftServer)minecraftServer).method_43496(arg_0), () -> {});
            }
        });
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(resourcePackBuilder -> {
            FontUtil.registerDefaultFonts((ResourcePackBuilder)resourcePackBuilder);
            GestureDialog.add(ModConfig.getInstance().addGestureDialog, resourcePackBuilder, () -> FontUtil.loadFont((ResourcePackBuilder)resourcePackBuilder, (class_2960)class_2960.method_60655((String)MODID, (String)"gesture")));
        });
        EntityRegistry.register();
        ItemRegistry.register();
        ServerPlayerEvents.COPY_FROM.register((serverPlayer, serverPlayer1, b) -> {
            GestureCameraHolder cameraHolder = (GestureCameraHolder)((Object)((Object)GestureController.GESTURE_CAMS.get((Object)serverPlayer.method_5667())));
            if (cameraHolder != null) {
                GestureController.onStop(cameraHolder);
            }
        });
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, resourceManager) -> this.loadAnimations());
        RESOURCEPACK_BUILDER = PolymerResourcePackUtils.createBuilder((Path)FabricLoader.getInstance().getGameDir().resolve("polymer/danse"));
        byte[] imageData = RESOURCEPACK_BUILDER.getDataOrSource("assets/minecraft/textures/entity/player/wide/steve.png");
        try {
            STEVE_TEXTURE = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ServerPlayConnectionEvents.JOIN.register((serverGamePacketListener, packetSender, minecraftServer) -> GestureController.onConnect(serverGamePacketListener.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((serverGamePacketListener, minecraftServer) -> GestureController.onDisconnect(serverGamePacketListener.field_14140));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> GestureCommand.register((CommandDispatcher<class_2168>)dispatcher));
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> {
            RESOURCEPACK_BUILDER = resourcePackBuilder;
        });
    }

    private static List<Path> loadFiles(String subDir, String suffix) throws IOException {
        Path dir = FabricLoader.getInstance().getConfigDir().resolve(subDir);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return List.of();
        }
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> list = stream.filter(p -> p.toString().endsWith(suffix)).toList();
            return list;
        }
    }

    private void loadAnimations() {
        try {
            for (Path path : Danse.loadFiles(MODID, ".ajblueprint")) {
                LOGGER.info("Loading player gesture model: {}", (Object)path.getFileName());
                PlayerModelRegistry.addFrom(PlayerModelLoader.load((String)path.toAbsolutePath().toString()));
            }
            boolean added = false;
            EmotecraftLoader loader = new EmotecraftLoader();
            for (Path path : Danse.loadFiles(MODID, ".json")) {
                LOGGER.info("Loading emotecraft emote: {}", (Object)path.getFileName());
                EmotecraftAnimationFile res = (EmotecraftAnimationFile)new Gson().fromJson((Reader)new InputStreamReader(new FileInputStream(path.toAbsolutePath().toString())), EmotecraftAnimationFile.class);
                loader.add(res);
                added = true;
            }
            if (added) {
                Model model = loader.loadResource(class_2960.method_60655((String)MODID, (String)"tightly-coupled"));
                PlayerModelRegistry.addFrom(model);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
        VIRTUAL_ENTITY_PICK_MAP = new Int2IntArrayMap();
    }
}

