/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.registry;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.danse.Danse;
import de.tomalbrc.danse.bbmodel.PlayerModelLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class PlayerModelRegistry {
    static Map<String, Model> animationModelMap = new Object2ObjectOpenHashMap();

    public static void addFrom(Model model) {
        for (String animationName : model.animations().keySet()) {
            Danse.LOGGER.info("Loaded animation {}", (Object)animationName);
            animationModelMap.put(animationName, model);
        }
    }

    public static void loadBuiltin() {
        ImmutableList sourceModels = ImmutableList.of((Object)"loosely-coupled", (Object)"tightly-coupled", (Object)"default");
        for (String filename : sourceModels) {
            Model model = new PlayerModelLoader().loadResource(class_2960.method_60655((String)"danse", (String)filename));
            for (String animationName : model.animations().keySet()) {
                animationModelMap.put(animationName, model);
            }
        }
    }

    public static Model getModel(String animationName) {
        return animationModelMap.get(animationName);
    }

    public static List<String> getAnimations() {
        return animationModelMap.keySet().stream().toList();
    }
}

