/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.bbmodel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import de.tomalbrc.bil.file.extra.ResourcePackModel;
import de.tomalbrc.bil.json.JSON;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;

public class PerPixelModelGenerator {
    private static final String MODEL_PREFIX = "danse:item/";
    private static final List<class_2350> DIRECTIONS = ImmutableList.of((Object)class_2350.field_11043, (Object)class_2350.field_11035, (Object)class_2350.field_11034, (Object)class_2350.field_11039, (Object)class_2350.field_11036, (Object)class_2350.field_11033);

    public static Map<String, byte[]> generatePerPixelModels(int px, int py, int pz, String partName, Map<String, ResourcePackModel.DisplayTransform> transformMap) {
        GridConfig grid = new GridConfig(px, py, pz);
        Object2ObjectArrayMap resources = new Object2ObjectArrayMap();
        ArrayList<ConditionModel> pixelModels = new ArrayList<ConditionModel>();
        Gson gson = JSON.GENERIC_BUILDER.create();
        PerPixelModelGenerator.calculateBases(grid.directionBases, grid.directionCounts, 0);
        PerPixelModelGenerator.generateAllModels(new GenerationContext((Map<String, byte[]>)resources, pixelModels, transformMap, partName, gson, grid));
        PerPixelModelGenerator.createCompositeModel((Map<String, byte[]>)resources, partName, gson, pixelModels);
        return resources;
    }

    private static void generateAllModels(GenerationContext ctx) {
        for (int x = 0; x < ctx.grid.px; ++x) {
            for (int y = 0; y < ctx.grid.py; ++y) {
                for (int z = 0; z < ctx.grid.pz; ++z) {
                    PerPixelModelGenerator.processCubeFaces(x, y, z, ctx);
                }
            }
        }
    }

    private static void processCubeFaces(int x, int y, int z, GenerationContext ctx) {
        for (int i = 0; i < DIRECTIONS.size(); ++i) {
            class_2350 dir = DIRECTIONS.get(i);
            if (!PerPixelModelGenerator.isFacePresent(x, y, z, dir, ctx.grid)) continue;
            PerPixelModelGenerator.createFaceModel(new FaceData(x, y, z, dir, i), ctx);
        }
    }

    private static boolean isFacePresent(int x, int y, int z, class_2350 direction, GridConfig grid) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> {
                if (z == 0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (z == grid.pz - 1) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (x == grid.px - 1) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (x == 0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11036 -> {
                if (y == grid.py - 1) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11033 -> y == 0;
        };
    }

    private static void createFaceModel(FaceData face, GenerationContext ctx) {
        int perFaceIndex = PerPixelModelGenerator.calculatePerFaceIndex(face, ctx.grid);
        int tintIndex = ctx.grid.directionBases[face.directionIndex] + perFaceIndex;
        Element element = PerPixelModelGenerator.createElement(face, ctx.grid);
        Model model = new Model(List.of(element), ctx.transformMap);
        String filename = PerPixelModelGenerator.createFilename(face, ctx);
        PerPixelModelGenerator.storeModel(ctx, model, filename, tintIndex);
    }

    private static int calculatePerFaceIndex(FaceData face, GridConfig grid) {
        return switch (face.direction) {
            case class_2350.field_11043, class_2350.field_11035 -> face.x + face.y * grid.px;
            case class_2350.field_11034, class_2350.field_11039 -> face.y + face.z * grid.py;
            default -> face.x + face.z * grid.px;
        };
    }

    private static Element createElement(FaceData face, GridConfig grid) {
        BoundingBox bb = new BoundingBox(face.x, face.y, face.z, grid);
        return new Element(bb.from(), bb.to(), (Map<String, Face>)ImmutableMap.of((Object)face.direction.method_10151(), (Object)Face.ZERO));
    }

    private static String createFilename(FaceData face, GenerationContext ctx) {
        return String.format("%d%d%d%s", face.x, face.y, face.z, Character.valueOf(face.direction.method_10151().charAt(0)));
    }

    private static void storeModel(GenerationContext ctx, Model model, String baseName, int tintIndex) {
        String filename = baseName + ".json";
        String path = "assets/danse/models/item/" + ctx.partName + "/" + filename;
        ctx.resources.put(path, ctx.gson.toJson((Object)model).getBytes(StandardCharsets.UTF_8));
        ctx.pixelModels.add(new ConditionModel(tintIndex, MODEL_PREFIX + ctx.partName + "/" + baseName));
    }

    private static void calculateBases(int[] bases, int[] counts, int start) {
        int acc = start;
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = acc;
            acc += counts[i];
        }
    }

    private static void createCompositeModel(Map<String, byte[]> resources, String partName, Gson gson, List<ConditionModel> pixelModels) {
        CompositeModel composite = new CompositeModel();
        composite.models.addAll(pixelModels);
        byte[] bytes = gson.toJson((Object)ImmutableMap.of((Object)"model", (Object)composite)).getBytes(StandardCharsets.UTF_8);
        resources.put("assets/danse/items/" + partName + ".json", bytes);
    }

    private static class GridConfig {
        final int px;
        final int py;
        final int pz;
        final double sizeX;
        final double sizeY;
        final double sizeZ;
        final int[] directionCounts;
        final int[] directionBases;

        GridConfig(int px, int py, int pz) {
            this.px = px;
            this.py = py;
            this.pz = pz;
            this.sizeX = 8.0 / (double)px;
            this.sizeY = 8.0 / (double)py;
            this.sizeZ = 8.0 / (double)pz;
            this.directionCounts = this.calculateDirectionCounts();
            this.directionBases = new int[DIRECTIONS.size()];
        }

        private int[] calculateDirectionCounts() {
            return new int[]{this.px * this.py, this.px * this.py, this.py * this.pz, this.py * this.pz, this.px * this.pz, this.px * this.pz};
        }
    }

    private record GenerationContext(Map<String, byte[]> resources, List<ConditionModel> pixelModels, Map<String, ResourcePackModel.DisplayTransform> transformMap, String partName, Gson gson, GridConfig grid) {
    }

    private record FaceData(int x, int y, int z, class_2350 direction, int directionIndex) {
    }

    static class Element {
        List<Double> from;
        List<Double> to;
        Map<String, Face> faces;

        Element(List<Double> from, List<Double> to, Map<String, Face> faces) {
            this.from = from;
            this.to = to;
            this.faces = faces;
        }
    }

    static class Model {
        ImmutableMap<String, String> textures = ImmutableMap.of((Object)"p", (Object)"danse:item/model", (Object)"particle", (Object)"#p");
        List<Element> elements;
        Map<String, ResourcePackModel.DisplayTransform> display;

        Model(List<Element> elements, Map<String, ResourcePackModel.DisplayTransform> display) {
            this.elements = elements;
            this.display = display;
        }
    }

    private static class BoundingBox {
        final double fromX;
        final double fromY;
        final double fromZ;
        final double toX;
        final double toY;
        final double toZ;

        BoundingBox(int x, int y, int z, GridConfig grid) {
            this.fromX = this.calculateFrom(x, grid.sizeX, 4.0);
            this.toX = this.fromX + grid.sizeX;
            this.fromY = this.calculateFrom(y, grid.sizeY, 0.0);
            this.toY = this.fromY + grid.sizeY;
            this.fromZ = this.calculateFrom(z, grid.sizeZ, 4.0);
            this.toZ = this.fromZ + grid.sizeZ;
        }

        private double calculateFrom(int coord, double size, double offset) {
            return (double)coord * size + offset;
        }

        List<Double> from() {
            return ImmutableList.of((Object)this.fromX, (Object)this.fromY, (Object)this.fromZ);
        }

        List<Double> to() {
            return ImmutableList.of((Object)this.toX, (Object)this.toY, (Object)this.toZ);
        }
    }

    static class Face {
        public static Face ZERO = new Face();
        List<Integer> uv = Arrays.asList(0, 0, 16, 16);
        String texture = "#p";
        int tintindex = 0;

        Face() {
        }
    }

    static class ConditionModel {
        String type = "minecraft:condition";
        String property = "minecraft:custom_model_data";
        int index;
        Map<String, Object> on_true;
        Map<String, Object> on_false = ImmutableMap.of((Object)"type", (Object)"minecraft:empty");

        ConditionModel(int tintIndex, String modelPath) {
            this.index = tintIndex;
            this.on_true = ImmutableMap.of((Object)"type", (Object)"minecraft:model", (Object)"model", (Object)modelPath, (Object)"tints", List.of(new Tint(tintIndex)));
        }
    }

    static class CompositeModel {
        String type = "minecraft:composite";
        List<ConditionModel> models = new ArrayList<ConditionModel>();

        CompositeModel() {
        }
    }

    static class Tint {
        String type = "minecraft:custom_model_data";
        int index;
        @SerializedName(value="default")
        int def = 0xFFFFFF;

        public Tint(int index) {
            this.index = index;
        }
    }
}

