/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.poly;

import de.tomalbrc.danse.GestureController;
import de.tomalbrc.danse.entity.GesturePlayerModelEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.BlockDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GestureCameraHolder
extends ElementHolder {
    private final BlockDisplayElement cameraElement = new BlockDisplayElement(this){

        public void notifyMove(class_243 oldPos, class_243 newPos, class_243 delta) {
            if (this.getHolder() != null) {
                class_10264 packet = new class_10264(this.getEntityId(), new class_10182(this.getCurrentPos(), class_243.field_1353, this.getYaw(), this.getPitch()), true);
                this.getHolder().sendPacket((class_2596)packet);
            }
        }
    };
    private final class_3222 player;
    private final class_243 origin;
    private final GesturePlayerModelEntity playerModel;
    private float pitch;
    private float yaw;
    private boolean dirtyRot = true;

    public GestureCameraHolder(class_3222 player, GesturePlayerModelEntity playerModel) {
        this.playerModel = playerModel;
        this.origin = player.method_19538();
        this.player = player;
        this.updatePos();
        this.cameraElement.setTeleportDuration(2);
        this.cameraElement.ignorePositionUpdates();
        this.addElement((VirtualElement)this.cameraElement);
    }

    public void setPitch(float pitch) {
        if (pitch != this.pitch) {
            this.pitch = pitch;
            this.dirtyRot = true;
        }
    }

    public void setYaw(float yaw) {
        if (yaw != this.yaw) {
            this.yaw = yaw;
            this.dirtyRot = true;
        }
    }

    public boolean startWatching(class_3244 player) {
        if (player.field_14140 == this.player) {
            return super.startWatching(player);
        }
        return false;
    }

    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> packetConsumer) {
        super.startWatchingExtraPackets(player, packetConsumer);
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.cameraElement.getEntityId(), (IntList)IntList.of((int)player.field_14140.method_5628())));
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createSetCameraEntityPacket((int)this.cameraElement.getEntityId()));
        packetConsumer.accept((class_2596<class_2602>)new class_2668(class_2668.field_25648, (float)class_1934.field_9219.method_8379()));
    }

    public void onTick() {
        super.onTick();
        if (this.player == null || this.player.method_31481() || !GestureController.GESTURE_CAMS.containsKey((Object)this.player.method_5667())) {
            this.destroy();
        } else {
            this.updatePos();
        }
    }

    public void destroy() {
        super.destroy();
        this.playerModel.method_31472();
    }

    private void updatePos() {
        Vector3f rotatedPoint = this.currentPoint(-4.0f);
        if (this.getAttachment() != null && this.dirtyRot) {
            class_3218 level = this.getAttachment().getWorld();
            class_243 eyePos = this.origin.method_1031(0.0, (double)(this.player.method_5751() / 2.0f), 0.0);
            class_3965 blockHitResult = level.method_17742(new class_3959(eyePos, new class_243(rotatedPoint), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
            Vector3f adjustedPos = this.currentPoint(-Math.max(class_3532.method_15379((float)((float)blockHitResult.method_17784().method_1022(eyePos))) - 0.5f, 0.1f));
            this.sendPacket((class_2596)new class_10264(this.cameraElement.getEntityId(), new class_10182(new class_243(adjustedPos), class_243.field_1353, this.yaw + 180.0f, this.pitch), false));
            this.dirtyRot = false;
        }
    }

    private Vector3f currentPoint(float dist) {
        Quaternionf xr = class_7833.field_40714.rotationDegrees(this.pitch).normalize();
        Quaternionf yr = class_7833.field_40715.rotationDegrees(this.yaw + 180.0f).normalize();
        Vector3f off = this.origin.method_46409().add(0.0f, this.player.method_5751() / 2.0f, 0.0f);
        return new Vector3f(0.0f, 0.0f, dist).rotate((Quaternionfc)yr.mul((Quaternionfc)xr)).add((Vector3fc)off);
    }

    public GesturePlayerModelEntity getPlayerModel() {
        return this.playerModel;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public class_243 getOrigin() {
        return this.origin;
    }

    public int getCameraId() {
        return this.cameraElement.getEntityId();
    }
}

