/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.danse.Danse;
import de.tomalbrc.danse.mixin.ArmorStandInvoker;
import de.tomalbrc.danse.poly.PlayerPartHolder;
import de.tomalbrc.danse.poly.StatuePlayerPartHolder;
import de.tomalbrc.danse.registry.ItemRegistry;
import de.tomalbrc.danse.registry.PlayerModelRegistry;
import de.tomalbrc.danse.util.MinecraftSkinParser;
import de.tomalbrc.danse.util.TextureCache;
import de.tomalbrc.danse.util.Util;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatuePlayerModelEntity
extends class_1531
implements AnimatedEntity {
    public static final class_2960 ID = Util.id("player_statue");
    private static final String PLAYER = "Player";
    private static final String URL = "URL";
    private static final String PLAYER_UUID = "PlayerUUID";
    protected PlayerPartHolder<?> holder;
    private boolean poseDirty = true;
    @Nullable
    protected String playerName;
    @Nullable
    protected UUID playerUuid;
    @Nullable
    protected String url;

    public StatuePlayerModelEntity(class_1299<? extends class_1531> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PlayerPartHolder<?> getHolder() {
        return this.holder;
    }

    public void setModel(Model model) {
        if (this.holder != null) {
            this.holder.destroy();
        }
        this.holder = new StatuePlayerPartHolder<StatuePlayerModelEntity>(this, model);
        this.holder.setupHitbox();
        EntityAttachment.ofTicking(this.holder, (class_1297)this);
    }

    public int getTeleportDuration() {
        return 2;
    }

    public float getShadowRadius() {
        return this.method_17681() * 0.5f;
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        if (this.holder == null) {
            this.setAnyModel();
        }
        this.playerUuid = valueInput.method_71426(PLAYER_UUID, class_4844.field_46588).orElse(null);
        this.playerName = valueInput.method_71428(PLAYER, null);
        this.url = valueInput.method_71428(URL, null);
        if (this.url != null && !this.url.isBlank()) {
            TextureCache.fetch(this.url, this::setTexture);
        } else if (this.playerName != null || this.playerUuid != null) {
            this.fetchGameProfile(this::setProfile);
            this.holder.setEquipment(this.field_56535);
        } else {
            this.setTexture(Danse.STEVE_TEXTURE);
        }
    }

    public void setAnyModel() {
        this.setModel(PlayerModelRegistry.getModel(PlayerModelRegistry.getAnimations().getFirst()));
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        if (this.playerName != null && !this.playerName.isBlank()) {
            valueOutput.method_71469(PLAYER, this.playerName);
        }
        if (this.playerUuid != null) {
            valueOutput.method_71468(PLAYER_UUID, class_4844.field_46588, (Object)this.playerUuid);
        }
    }

    public void method_6116(class_1304 equipmentSlot, class_1799 itemStack, class_1799 itemStack2) {
        super.method_6116(equipmentSlot, itemStack, itemStack2);
        if (!this.method_37908().method_8608() && !this.method_7325()) {
            this.holder.setEquipment(this.field_56535);
        }
    }

    public void setProfile(Optional<GameProfile> profile) {
        profile.ifPresent(gameProfile -> {
            this.playerName = gameProfile.getName();
            this.playerUuid = gameProfile.getId();
        });
        profile.ifPresentOrElse(gameProfile -> TextureCache.fetch(gameProfile, this::setTexture), () -> this.setTexture(Danse.STEVE_TEXTURE));
    }

    public void setTexture(BufferedImage image) {
        MinecraftSkinParser.calculate(image, data -> this.holder.setSkinData((Map<MinecraftSkinParser.BodyPart, MinecraftSkinParser.PartData>)data));
    }

    public void fetchGameProfile(Consumer<Optional<GameProfile>> cb) {
        if (this.playerUuid != null) {
            class_2631.method_59539((UUID)this.playerUuid).thenAccept(cb);
        }
        if (this.playerName != null && !this.playerName.isBlank()) {
            class_2631.method_52580((String)this.playerName).thenAccept(cb);
        }
    }

    @NotNull
    public class_1799 method_31480() {
        class_1799 stack = ItemRegistry.PLAYER_STATUE.method_7854();
        stack.method_57379(class_9334.field_49617, (Object)new class_9296(Optional.ofNullable(this.playerName), Optional.ofNullable(this.playerName == null ? this.playerUuid : null), new PropertyMap()));
        return stack;
    }

    public void customBrokenByPlayer(class_3218 serverLevel, class_1282 damageSource) {
        class_1799 itemStack = new class_1799((class_1935)ItemRegistry.PLAYER_STATUE);
        itemStack.method_57379(class_9334.field_49617, (Object)new class_9296(Optional.ofNullable(this.playerName), Optional.ofNullable(this.playerUuid), new PropertyMap()));
        itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)itemStack);
        ((ArmorStandInvoker)((Object)this)).invokeBrokenByAnything(serverLevel, damageSource);
    }

    public boolean isPoseDirty() {
        return this.poseDirty || this.method_37908().method_8510() - this.field_7112 < 5L;
    }

    public void setPoseDirty(boolean dirty) {
        this.poseDirty = dirty;
    }

    public void method_6919(class_2379 rotations) {
        super.method_6919(rotations);
        this.poseDirty = true;
    }

    public void method_6927(class_2379 rotations) {
        super.method_6927(rotations);
        this.poseDirty = true;
    }

    public void method_6910(class_2379 rotations) {
        super.method_6910(rotations);
        this.poseDirty = true;
    }

    public void method_6925(class_2379 rotations) {
        super.method_6925(rotations);
        this.poseDirty = true;
    }

    public void method_6909(class_2379 rotations) {
        super.method_6909(rotations);
        this.poseDirty = true;
    }

    public void method_6926(class_2379 rotations) {
        super.method_6926(rotations);
        this.poseDirty = true;
    }
}

