/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.danse.poly;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.bil.core.component.AnimationComponent;
import de.tomalbrc.bil.core.element.PerPlayerBlockDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerItemDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerTextDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerTransformableElement;
import de.tomalbrc.bil.core.extra.DisplayElementUpdateListener;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.entity.simple.SimpleEntityHolder;
import de.tomalbrc.bil.core.holder.wrapper.AbstractWrapper;
import de.tomalbrc.bil.core.holder.wrapper.BlockBone;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.holder.wrapper.ItemBone;
import de.tomalbrc.bil.core.holder.wrapper.Locator;
import de.tomalbrc.bil.core.holder.wrapper.ModelBone;
import de.tomalbrc.bil.core.holder.wrapper.TextBone;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.danse.Danse;
import de.tomalbrc.danse.entity.GesturePlayerModelEntity;
import de.tomalbrc.danse.entity.StatuePlayerModelEntity;
import de.tomalbrc.danse.util.MinecraftSkinParser;
import de.tomalbrc.danse.util.TextureCache;
import de.tomalbrc.danse.util.Util;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10630;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2739;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PlayerPartHolder<T extends StatuePlayerModelEntity>
extends SimpleEntityHolder<T> {
    private boolean didFirstRun = false;
    protected InteractionElement hitboxInteraction;
    protected Map<MinecraftSkinParser.BodyPart, DisplayWrapper<PerPlayerItemDisplayElement>> locatorPartMap = new Object2ObjectArrayMap();
    private boolean didSetup;

    public PlayerPartHolder(T parent, Model model) {
        super(parent, model);
    }

    public void setupHitbox() {
        this.hitboxInteraction = InteractionElement.redirect((class_1297)this.parent);
        this.hitboxInteraction.setSize(this.dimensions.comp_2185(), this.dimensions.comp_2186());
        this.hitboxInteraction.ignorePositionUpdates();
        Danse.VIRTUAL_ENTITY_PICK_MAP.put(this.hitboxInteraction.getEntityId(), ((StatuePlayerModelEntity)this.parent).method_5628());
        this.addElement((VirtualElement)this.hitboxInteraction);
    }

    public void setLocatorItem(MinecraftSkinParser.BodyPart part, String name, class_1799 itemStack) {
        if (!this.locatorPartMap.containsKey((Object)part)) {
            DisplayWrapper<PerPlayerItemDisplayElement> e = this.addLocatorElement(name, itemStack, part.getContext());
            if (e != null) {
                ((PerPlayerItemDisplayElement)e.element()).setItem(itemStack);
                this.locatorPartMap.put(part, e);
            }
        } else {
            ((PerPlayerItemDisplayElement)this.locatorPartMap.get((Object)part).element()).setItem(itemStack);
        }
    }

    public DisplayWrapper<PerPlayerItemDisplayElement> addLocatorElement(String name, class_1799 stack, class_811 context) {
        Locator locator = this.getLocator(name);
        if (this.didSetup && locator != null) {
            PerPlayerItemDisplayElement element = this.createLocatorItemDisplay(stack, context);
            DisplayWrapper display = new DisplayWrapper((PerPlayerTransformableElement)element, (AbstractWrapper)locator, false);
            locator.addListener((Locator.LocatorListener)new DisplayElementUpdateListener(display));
            this.initializeDisplay(display);
            this.addAdditionalDisplay((DisplayElement)element);
            return display;
        }
        return null;
    }

    private PerPlayerItemDisplayElement createLocatorItemDisplay(class_1799 stack, class_811 context) {
        PerPlayerItemDisplayElement element = new PerPlayerItemDisplayElement(stack.method_7972());
        element.ignorePositionUpdates();
        element.setItemDisplayContext(context);
        element.setInterpolationDuration(1);
        return element;
    }

    protected void updateLocator(class_3222 serverPlayer, Locator locator) {
        AnimationComponent.PoseQueryResult queryResult;
        if ((this.isDirty() || this.getAnimator().hasRunningAnimations()) && locator.requiresUpdate() && (queryResult = this.animationComponent.findPose(serverPlayer, (AbstractWrapper)locator)) != null) {
            Pose pose;
            Pose pose2 = pose = queryResult.pose() == null ? locator.getLastPose(serverPlayer) : queryResult.pose();
            if (pose != null) {
                locator.updateListeners(queryResult.owner(), (AbstractAnimationHolder)this, pose);
            } else {
                locator.updateListeners(queryResult.owner(), (AbstractAnimationHolder)this, locator.getDefaultPose());
            }
        }
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        super.onAttachmentRemoved(oldAttachment);
        if (this.hitboxInteraction != null) {
            Danse.VIRTUAL_ENTITY_PICK_MAP.remove(this.hitboxInteraction.getEntityId());
        }
    }

    public int[] getDisplayIds() {
        int[] displays = new int[this.bones.length + this.additionalDisplays.size() + (this.hitboxInteraction == null ? 0 : 1)];
        int index = 0;
        for (Bone bone : this.bones) {
            displays[index++] = bone.element().getEntityId();
        }
        for (DisplayElement element : this.additionalDisplays) {
            displays[index++] = element.getEntityId();
        }
        if (this.hitboxInteraction != null) {
            displays[displays.length - 1] = this.hitboxInteraction.getEntityId();
        }
        return displays;
    }

    public void setSkinData(Map<MinecraftSkinParser.BodyPart, MinecraftSkinParser.PartData> data) {
        for (Bone x : this.bones) {
            MultipartModelBone bone;
            MinecraftSkinParser.BodyPart part;
            if (!(x instanceof MultipartModelBone) || (part = MinecraftSkinParser.BodyPart.partFrom((bone = (MultipartModelBone)x).name())) == MinecraftSkinParser.BodyPart.NONE) continue;
            class_1799 item = ((PerPlayerItemDisplayElement)bone.element()).getItem();
            MinecraftSkinParser.PartData partData = data.get((Object)part);
            item.method_57379(class_9334.field_54199, (Object)part.modelId(partData.slim() && part.isArm()));
            item.method_57379(class_9334.field_49637, (Object)partData.customModelDataInner());
            ((PerPlayerItemDisplayElement)bone.element()).getDataTracker().set(DisplayTrackedData.Item.ITEM, (Object)item, true);
            class_1799 outerItem = item.method_7972();
            outerItem.method_57379(class_9334.field_49637, (Object)partData.customModelDataOuter());
            bone.outer.getDataTracker().set(DisplayTrackedData.Item.ITEM, (Object)outerItem, true);
        }
        this.setDisplayProps();
    }

    public void setEquipment(class_10630 equipment) {
        for (Bone x : this.bones) {
            MultipartModelBone bone;
            MinecraftSkinParser.BodyPart part;
            if (!(x instanceof MultipartModelBone) || (part = MinecraftSkinParser.BodyPart.partFrom((bone = (MultipartModelBone)x).name())) == MinecraftSkinParser.BodyPart.NONE) continue;
            class_1799 item = ((PerPlayerItemDisplayElement)bone.element()).getItem().method_7972();
            item.method_57379(class_9334.field_54199, (Object)part.modelId(false));
            boolean isBody = part == MinecraftSkinParser.BodyPart.BODY;
            boolean isLeg = part.isLeg();
            class_1799 armorItem = item.method_7972();
            armorItem.method_57379(class_9334.field_49637, (Object)TextureCache.armorCustomModelData(part, equipment.method_66659(isBody ? class_1304.field_6172 : part.getSlot()), true));
            bone.armor.getDataTracker().set(DisplayTrackedData.Item.ITEM, (Object)armorItem, true);
            class_1799 armorItemOuter = item.method_7972();
            armorItemOuter.method_57379(class_9334.field_49637, (Object)TextureCache.armorCustomModelData(part, equipment.method_66659(isLeg ? class_1304.field_6166 : part.getSlot()), false));
            bone.armorOuter.getDataTracker().set(DisplayTrackedData.Item.ITEM, (Object)armorItemOuter, true);
        }
        this.setLocatorItem(MinecraftSkinParser.BodyPart.LEFT_ARM, "offhand", equipment.method_66659(class_1304.field_6171));
        this.setLocatorItem(MinecraftSkinParser.BodyPart.RIGHT_ARM, "mainhand", equipment.method_66659(class_1304.field_6173));
        this.setDisplayProps();
    }

    private void setDisplayProps() {
        for (VirtualElement element : this.getElements()) {
            if (!(element instanceof DisplayElement)) continue;
            DisplayElement displayElement = (DisplayElement)element;
            displayElement.setViewRange(0.5f);
            displayElement.setInvisible(true);
            displayElement.setDisplaySize(5.0f, 5.0f);
            displayElement.setTeleportDuration(2);
            displayElement.setInterpolationDuration(2);
        }
    }

    protected boolean isDirty() {
        return !this.didFirstRun;
    }

    protected void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display) {
        AnimationComponent.PoseQueryResult queryResult = this.animationComponent.findPose(serverPlayer, display);
        if (queryResult != null) {
            if (queryResult.owner() != serverPlayer && display.element().getDataTracker().isDirty()) {
                return;
            }
            this.updateElement(queryResult.owner(), display, queryResult.pose());
        } else if (this.isDirty()) {
            this.updateElement(null, display, display.getLastPose(serverPlayer));
        }
    }

    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        MultipartModelBone multipartModelBone;
        if (display instanceof MultipartModelBone) {
            multipartModelBone = (MultipartModelBone)display;
            multipartModelBone.setYaw(((StatuePlayerModelEntity)this.parent).method_36454());
        } else {
            display.element().setYaw(((StatuePlayerModelEntity)this.parent).method_36454());
        }
        if (this.hitboxInteraction != null) {
            this.hitboxInteraction.setYaw(((StatuePlayerModelEntity)this.parent).method_36454());
        }
        super.updateElement(serverPlayer, display, pose);
        if (pose == null) {
            if (this.isDirty()) {
                pose = display.getDefaultPose();
            } else {
                return;
            }
        }
        if (display instanceof MultipartModelBone) {
            multipartModelBone = (MultipartModelBone)display;
            if (pose != null) {
                Matrix4f mat1;
                Matrix4f mat = Util.compose(null, pose.readOnlyLeftRotation(), pose.readOnlyScale(), pose.readOnlyRightRotation());
                Quaternionfc rotation = this.rotation(multipartModelBone.bodyPart);
                if (rotation != null) {
                    mat1 = new Matrix4f((Matrix4fc)mat);
                    mat1.mul((Matrix4fc)new Matrix4f().rotate(rotation));
                    mat1.translateLocal(pose.readOnlyTranslation());
                    display.element().setTransformation(null, mat1);
                    DisplayWrapper<PerPlayerItemDisplayElement> l = this.locatorPartMap.get((Object)multipartModelBone.bodyPart);
                    if (l != null) {
                        Matrix4f locatorMatrix = new Matrix4f((Matrix4fc)mat1);
                        locatorMatrix.translate(l.node().transform().origin());
                        locatorMatrix.rotate((Quaternionfc)l.getDefaultPose().matrix().getNormalizedRotation(new Quaternionf()));
                        locatorMatrix.rotateX((float)Math.PI);
                        locatorMatrix.rotateY((float)Math.PI);
                        ((PerPlayerItemDisplayElement)l.element()).setTransformation(locatorMatrix);
                        ((PerPlayerItemDisplayElement)l.element()).startInterpolationIfDirty();
                        ((PerPlayerItemDisplayElement)l.element()).setYaw(((StatuePlayerModelEntity)this.parent).method_36454());
                    }
                }
                if (multipartModelBone.outer != null) {
                    mat1 = new Matrix4f((Matrix4fc)mat);
                    if (rotation != null) {
                        mat1.mul((Matrix4fc)new Matrix4f().rotate(rotation));
                    }
                    mat1.translate(0.0f, this.offset(multipartModelBone), 0.0f);
                    mat1.scale(1.05f);
                    mat1.translateLocal(pose.readOnlyTranslation());
                    multipartModelBone.outer.setTransformation(mat1);
                }
                if (multipartModelBone.armor != null) {
                    mat1 = new Matrix4f((Matrix4fc)mat);
                    if (rotation != null) {
                        mat1.mul((Matrix4fc)new Matrix4f().rotate(rotation));
                    }
                    mat1.translate(0.0f, this.offset(multipartModelBone), 0.0f);
                    mat1.scale(1.1f);
                    mat1.translateLocal(pose.readOnlyTranslation());
                    multipartModelBone.armor.setTransformation(mat1);
                }
                if (multipartModelBone.armorOuter != null) {
                    mat1 = new Matrix4f((Matrix4fc)mat);
                    if (rotation != null) {
                        mat1.mul((Matrix4fc)new Matrix4f().rotate(rotation));
                    }
                    mat1.translate(0.0f, this.offsetArmor(multipartModelBone), 0.0f);
                    mat1.scale(1.2f);
                    mat1.translateLocal(pose.readOnlyTranslation());
                    multipartModelBone.armorOuter.setTransformation(mat1);
                }
                for (ItemDisplayElement part : multipartModelBone.additionalElements()) {
                    part.setYaw(((StatuePlayerModelEntity)this.parent).method_36454());
                    part.setInterpolationDuration(2);
                    part.setTeleportDuration(2);
                    part.startInterpolationIfDirty();
                }
            }
        }
    }

    protected Quaternionfc rotation(MinecraftSkinParser.BodyPart part) {
        return null;
    }

    protected float offset(MultipartModelBone bone) {
        boolean body;
        boolean leg = bone.part().isLeg();
        boolean arm = bone.part().isArm();
        boolean bl = body = bone.part() == MinecraftSkinParser.BodyPart.BODY;
        return leg ? 0.04f : (arm ? 0.015f : (body ? -0.015f : 0.0f));
    }

    protected float offsetArmor(MultipartModelBone bone) {
        boolean leg = bone.part().isLeg();
        boolean arm = bone.part().isArm();
        return leg ? 0.1f : (arm ? 0.04f : -0.04f);
    }

    @Nullable
    protected PerPlayerItemDisplayElement createBoneDisplay(class_2960 modelData) {
        PerPlayerItemDisplayElement display = super.createBoneDisplay(modelData);
        if (display == null) {
            return null;
        }
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8407);
        itemStack.method_57379(class_9334.field_54199, (Object)modelData);
        display.setItem(itemStack);
        return display;
    }

    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        super.startWatchingExtraPackets(player, consumer);
        class_1297 class_12972 = this.parent;
        if (class_12972 instanceof GesturePlayerModelEntity) {
            GesturePlayerModelEntity gesturePlayerModel = (GesturePlayerModelEntity)class_12972;
            ObjectArrayList data = new ObjectArrayList();
            data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))));
            consumer.accept((class_2596<class_2602>)new class_2739(gesturePlayerModel.getPlayer().method_5628(), (List)data));
        }
    }

    public void setAttachment(@Nullable HolderAttachment attachment) {
        super.setAttachment(attachment);
        if (attachment != null) {
            for (Bone bone : this.bones) {
                if (!(bone instanceof MultipartModelBone)) continue;
                MultipartModelBone multipartModelBone = (MultipartModelBone)bone;
                for (ItemDisplayElement element : multipartModelBone.additionalElements()) {
                    this.addAdditionalDisplay((DisplayElement)element);
                }
            }
        }
    }

    protected void setupElements(List<Bone<?>> bones) {
        block7: for (Node node : this.model.nodeMap().values()) {
            Pose defaultPose = (Pose)this.model.defaultPose().get((Object)node.uuid());
            MinecraftSkinParser.BodyPart part = MinecraftSkinParser.BodyPart.partFrom(node.name());
            switch (node.type()) {
                case BONE: {
                    PerPlayerItemDisplayElement boneDisplay = this.createBoneDisplay(node.modelData());
                    if (part != MinecraftSkinParser.BodyPart.NONE) {
                        PerPlayerItemDisplayElement boneDisplayOuter = this.createBoneDisplay(node.modelData());
                        PerPlayerItemDisplayElement boneDisplayArmor = this.createBoneDisplay(node.modelData());
                        PerPlayerItemDisplayElement boneDisplayArmorOuter = this.createBoneDisplay(node.modelData());
                        if (boneDisplay == null) continue block7;
                        bones.add((Bone<?>)MultipartModelBone.of(boneDisplay, boneDisplayOuter, boneDisplayArmor, boneDisplayArmorOuter, node, defaultPose));
                        this.addElement((VirtualElement)boneDisplay);
                        break;
                    }
                    if (boneDisplay == null) break;
                    bones.add((Bone<?>)ModelBone.of((PerPlayerItemDisplayElement)boneDisplay, (Node)node, (Pose)defaultPose));
                    this.addElement((VirtualElement)boneDisplay);
                    break;
                }
                case ITEM: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTextDisplayElement bone = this.createItemDisplayElement(((class_1792)class_7923.field_41178.method_63535(node.displayDataElement().getItem())).method_7854());
                    bone.setInterpolationDuration(2);
                    bone.setTeleportDuration(2);
                    bones.add((Bone<?>)ItemBone.of((PerPlayerItemDisplayElement)bone, (Node)node, (Pose)defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case BLOCK: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTextDisplayElement bone = this.createBlockDisplayElement(((class_2248)class_7923.field_41175.method_63535(node.displayDataElement().getBlock())).method_9564());
                    bone.setInterpolationDuration(2);
                    bone.setTeleportDuration(2);
                    bones.add((Bone<?>)BlockBone.of((PerPlayerBlockDisplayElement)bone, (Node)node, (Pose)defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case TEXT: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTextDisplayElement bone = this.createTextDisplayElement((class_2561)class_2561.method_43470((String)node.displayDataElement().getText()));
                    bone.setInterpolationDuration(2);
                    bone.setTeleportDuration(2);
                    bones.add((Bone<?>)TextBone.of((PerPlayerTextDisplayElement)bone, (Node)node, (Pose)defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case LOCATOR: {
                    this.locatorMap.put((Object)node.name(), (Object)Locator.of((Node)node, (Pose)defaultPose));
                }
            }
        }
        this.didSetup = true;
    }

    protected void onAsyncTick() {
        super.onAsyncTick();
        this.didFirstRun = true;
    }

    public static class MultipartModelBone
    extends ModelBone {
        public final ItemDisplayElement outer;
        public final ItemDisplayElement armor;
        public final ItemDisplayElement armorOuter;
        public final MinecraftSkinParser.BodyPart bodyPart;

        protected MultipartModelBone(PerPlayerItemDisplayElement element, PerPlayerItemDisplayElement outer, PerPlayerItemDisplayElement armor, PerPlayerItemDisplayElement armorOuter, Node node, Pose defaultPose, boolean isHead) {
            super(element, node, defaultPose, isHead);
            this.outer = outer;
            this.armor = armor;
            this.armorOuter = armorOuter;
            this.bodyPart = MinecraftSkinParser.BodyPart.partFrom(node.name());
        }

        public MinecraftSkinParser.BodyPart part() {
            return this.bodyPart;
        }

        public static MultipartModelBone of(PerPlayerItemDisplayElement inner, PerPlayerItemDisplayElement outer, PerPlayerItemDisplayElement armor, PerPlayerItemDisplayElement armorOuter, @NotNull Node node, Pose defaultPose) {
            return new MultipartModelBone(inner, outer, armor, armorOuter, node, defaultPose, false);
        }

        public ImmutableList<ItemDisplayElement> additionalElements() {
            return ImmutableList.of((Object)((ItemDisplayElement)this.element()), (Object)this.outer, (Object)this.armor, (Object)this.armorOuter);
        }

        public void setYaw(float yRot) {
            for (ItemDisplayElement element : this.additionalElements()) {
                element.setYaw(yRot);
            }
        }
    }
}

