/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.model.color.BlockColor;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelRegistry;
import com.gtnewhorizon.gtnhlib.client.model.state.BlockState;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class ModelISBRH
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final ModelISBRH INSTANCE = new ModelISBRH();
    public static final int JSON_ISBRH_ID = RenderingRegistry.getNextAvailableRenderId();
    private final Random RAND = new Random();

    public BakedModel getModel(IBlockAccess world, Block block, int meta, int x, int y, int z) {
        return ModelRegistry.getBakedModel(new BlockState(block, meta));
    }

    public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Random random;
        if (world instanceof World) {
            World worldIn = (World)world;
            random = worldIn.rand;
        } else {
            random = this.RAND;
        }
        Random random2 = random;
        Tessellator tesselator = TessellatorManager.get();
        int meta = world.getBlockMetadata(x, y, z);
        BakedModel model = this.getModel(world, block, meta, x, y, z);
        int color = model.getColor(world, x, y, z, block, meta, random2);
        boolean rendered = false;
        for (ModelQuadFacing dir : ModelQuadFacing.DIRECTIONS) {
            List<ModelQuadView> quads = model.getQuads(world, x, y, z, block, meta, dir, random2, color, null);
            if (quads.isEmpty()) continue;
            rendered = true;
            for (ModelQuadView quad : quads) {
                int quadColor = color;
                if (quad.getColorIndex() != -1) {
                    quadColor = BlockColor.getColor(block, world, x, y, z, meta, quad.getColorIndex());
                }
                float r = (float)(quadColor & 0xFF) / 255.0f;
                float g = (float)(quadColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(quadColor >> 16 & 0xFF) / 255.0f;
                int lm = this.getLightMap(block, quad, dir, world, x, y, z, renderer);
                tesselator.setBrightness(lm);
                float shade = ModelISBRH.diffuseLight(quad.getComputedFaceNormal());
                tesselator.setColorOpaque_F(r * shade, g * shade, b * shade);
                this.renderQuad(quad, x, y, z, tesselator, null);
            }
        }
        return rendered;
    }

    public void renderQuad(ModelQuadView quad, float x, float y, float z, Tessellator tessellator, @Nullable IIcon overrideIcon) {
        for (int i = 0; i < 4; ++i) {
            tessellator.addVertexWithUV((double)(quad.getX(i) + x), (double)(quad.getY(i) + y), (double)(quad.getZ(i) + z), (double)quad.getTexU(i), (double)quad.getTexV(i));
        }
    }

    public int getLightMap(Block block, ModelQuadView quad, ModelQuadFacing dir, IBlockAccess world, int x, int y, int z, RenderBlocks rb) {
        float avgPos = this.getAveragePos(quad, dir);
        switch (dir) {
            case POS_X: 
            case POS_Y: 
            case POS_Z: {
                if (!((double)avgPos >= 1.0)) break;
                int lx = x + dir.getStepX();
                int ly = y + dir.getStepY();
                int lz = z + dir.getStepZ();
                return block.getMixedBrightnessForBlock(world, lx, ly, lz);
            }
            case NEG_X: 
            case NEG_Y: 
            case NEG_Z: {
                if (!((double)avgPos <= 0.0)) break;
                int lx = x + dir.getStepX();
                int ly = y + dir.getStepY();
                int lz = z + dir.getStepZ();
                return block.getMixedBrightnessForBlock(world, lx, ly, lz);
            }
        }
        if (block.getLightOpacity(world, x, y, z) != 0) {
            return block.getMixedBrightnessForBlock(world, x, y, z);
        }
        int lm = block.getMixedBrightnessForBlock(world, x, y, z);
        for (int i = 0; i < 6; ++i) {
            ModelQuadFacing neighbor = ModelQuadFacing.DIRECTIONS[i];
            int lx = x + neighbor.getStepX();
            int ly = y + neighbor.getStepY();
            int lz = z + neighbor.getStepZ();
            lm = Math.max(lm, block.getMixedBrightnessForBlock(world, lx, ly, lz));
        }
        return lm;
    }

    private float getAveragePos(ModelQuadView quad, ModelQuadFacing dir) {
        float avg = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f;
            switch (dir.getAxis()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    f = quad.getX(i);
                    break;
                }
                case Y: {
                    f = quad.getY(i);
                    break;
                }
                case Z: {
                    f = quad.getZ(i);
                }
            }
            avg += f;
        }
        return avg / 4.0f;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return JSON_ISBRH_ID;
    }

    public static float diffuseLight(int normal) {
        float nx = NormI8.unpackX(normal);
        float ny = NormI8.unpackY(normal);
        float nz = NormI8.unpackZ(normal);
        return Math.min(nx * nx * 0.6f + ny * ny * ((3.0f + ny) / 4.0f) + nz * nz * 0.8f, 1.0f);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        if (block == null) {
            return;
        }
        int meta = stack.getItemDamage();
        Tessellator tesselator = TessellatorManager.get();
        BakedModel model = this.getModel(null, block, meta, 0, 0, 0);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        tesselator.startDrawingQuads();
        int color = model.getColor(null, 0, 0, 0, block, meta, this.RAND);
        for (ModelQuadFacing dir : ModelQuadFacing.DIRECTIONS) {
            List<ModelQuadView> quads = model.getQuads(null, 0, 0, 0, block, meta, dir, this.RAND, color, null);
            if (quads.isEmpty()) continue;
            for (ModelQuadView quad : quads) {
                int quadColor = color;
                if (quad.getColorIndex() != -1) {
                    quadColor = BlockColor.getColor(block, stack, quad.getColorIndex());
                }
                float r = (float)(quadColor & 0xFF) / 255.0f;
                float g = (float)(quadColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(quadColor >> 16 & 0xFF) / 255.0f;
                float shade = ModelISBRH.diffuseLight(quad.getComputedFaceNormal());
                tesselator.setColorOpaque_F(r * shade, g * shade, b * shade);
                this.renderQuad(quad, 0.0f, 0.0f, 0.0f, tesselator, null);
            }
        }
        this.applyItemDisplay(type);
        tesselator.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void applyItemDisplay(IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslated((double)0.0, (double)-0.1f, (double)0.0);
        }
    }

    public IIcon getParticleIcon(Block block, IBlockAccess world, int x, int y, int z, int meta) {
        BakedModel model = this.getModel(world, block, meta, x, y, z);
        return model.getParticle(meta, this.RAND);
    }

    public boolean isMissingIcon(IIcon icon) {
        if (icon == null) {
            return false;
        }
        String name = icon.getIconName();
        if (name == null) {
            return false;
        }
        if (name.equals("missingno")) {
            return false;
        }
        return !name.startsWith("MISSING_ICON_BLOCK_");
    }
}

